<?

require("core/basic.php");
require("core/construct.php");
require("core/functions.php");
require_once(__DIR__ . "/util/utils.php");

//メール送信
require_once('../admin/vendor/google-api-php-client-2.4.1/quickstart.php');

try{

    $log->info('Starting password reissue email.',
        array(
            'file' => __FILE__,
            'user_id'=> $POST['user_id'])
    );

    $POST = filterPost();
    $GET = filterGet();

    if(empty($POST['user_id'])) throw new Exception("ユーザーIDを入力してください。");
    $user_id = $POST['user_id'];

    if(empty($POST['email'])) throw new Exception("認証用メールアドレスを入力してください。");
    $email = $POST['email'];


    require_once(MDL_PATH."model.php");
    $sapMDL = new sappModel($sdb, $link);


    $u_row = $sapMDL->GetUserInfo($user_id);
    if(!$u_row) throw new Exception("入力されたユーザーは存在していません。");

    if(preg_match('/^[a-zA-Z0-9_+-]+(.[a-zA-Z0-9_+-]+)*@([a-zA-Z0-9][a-zA-Z0-9-]*[a-zA-Z0-9]*\.)+[a-zA-Z]{2,}$/', $email, $matches) != 1) throw new Exception("認証用メールアドレスには正しいメールアドレスを入力してください。");
    if(mb_strlen($email) > 512) throw new Exception("認証用メールアドレスは512文字以内です。");



    $options = [ 'cost' => 8, 'salt' => $ini['user_magic_code']];
    $token = password_hash($user_id, PASSWORD_DEFAULT);

    $t = new Datetime();
    $hash = base64_encode($user_id.'_'.$t->modify('+ 10 minute')->getTimestamp().'_'.$token);

    // パスワード再発行認証メール送信
    $info = [];
//     $info['email'] = $u_row['uuid'];
    $info['email'] = $email;
    $info['from_addr'] = GOOGLE_MAIL_INFO;

    $info['subject'] = "スーパーアプリ　パスワード再発行認証";

    $br = "\n";

    $info['body'] .= "パスワード再発行認証のため、下記のURLにアクセスし、再発行申請を行ってください。".$br;
    $info['body'] .= "=============================================".$br;
    $info['body'] .= BASE_URL."remainder_auth.php?tid=".$GET['tid']."&token=".$hash.$br;
    $info['body'] .= "=============================================".$br;
    $info['body'] .= $br;

    $client = getClient();
    $mail_ret = sendGmail($client, $info);

    if(isset($mail_ret->error)) throw new Exception("パスワード再発行認証メールの送信に失敗しました。");
    $mes = GetMsgEncode('パスワード再発行認証メールを送信しました。');

    // パスワード再発行メール送信成功時ログ
    $log->info('Successful password reissue email.',
        array(
            'file' => __FILE__,
            'user_id' => $POST['user_id']
        )
    );

    header( 'Location: login.php?m='.$mes.'&tid='.$GET['tid']);
    exit;

}catch(Exception $e){
    $mes = GetMsgEncode($e->getMessage());

    // パスワード再発行メール失敗時ログ
    $log->info($e);
    $log->info('Failed to password reissue email.',
        array(
            'file' => __FILE__,
            'user_id' => $POST['user_id'],
            'message' => $e->getMessage()
        )
    );

    header( 'Location: login.php?m='.$mes.'&err&tid='.$GET['tid']);
    exit;
}


?>