<?
/**
 * パスワード再発行画面
 */

require("core/basic.php");
require("core/construct.php");
require("core/functions.php");

try{

    $POST = filterPost();
    $GET = filterGet();

    if(empty($GET['token'])) throw new Exception("認証トークンが設定されていません。");
    if(empty($GET['tid'])) throw new Exception("ビルが指定されていません。");

    $hash = $GET['token'];
    $hash_arr = explode("_",base64_decode($hash));

    require_once(MDL_PATH."model.php");
    $sapMDL = new sappModel($sdb, $link);

    $u_row = $sapMDL->GetUserInfo($hash_arr[0]);
    if(!$u_row) throw new Exception("指定されたユーザーは存在していません。");

    $t = new Datetime();
    if($t->getTimestamp() > $hash_arr[1]) throw new Exception("認証トークンの期限が切れています。");


    $ret = password_verify($hash_arr[0], $hash_arr[2]);
    if(!$ret) throw new Exception('認証トークンが正しくありません。');


    //　ログイン処理
    session_start();
    session_regenerate_id();
    $_SESSION['login']['user_id'] = $u_row['user_id'];
    $_SESSION['login']['name'] = $u_row['name'];
    $_SESSION['login']['tenant_id'] = $u_row['tenant_id'];
    $_SESSION['login']['build'] = $GET['tid'];


    $ll = new Datetime();
    $prm = [
        'user_id' => $u_row['user_id'],
        'login_count' => (int)++$u_row['login_count'],
        'last_login' => $ll->format("Y-m-d H:i:s"),
    ];
    $up_ret = $sapMDL->LoginSuccess($prm);

    header( 'Location: password_reset.php?tid='.$GET['tid']);
    exit;


}catch(Exception $e){
    $mes = GetMsgEncode($e->getMessage());
    header( 'Location: login.php?m='.$mes.'&err&tid='.$GET['tid']);
    exit;
}

?>