<?php

require("../../core/construct.php");
require(CORE_PATH."functions.php");
require(CORE_PATH."session_check.php");
require_once(__DIR__."/../../util/utils.php");

try{
    require(SIGNAGE_ROOT."model/model.php");
    $sgMDL = new sngModel($sdb, $link);
    require(SUPER_APPLI_ROOT."model/model.php");
    $sapMDL = new sappModel($sdb, $link);
    require(ADMIN_ROOT."model/model.php");
    $admMDL = new admModel($sdb, $link);

    $POST = filterPost();

    if(!isset($_SERVER['HTTP_X_REQUESTED_WITH']) || strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) !== 'xmlhttprequest') {
        throw new Exception('安全な接続ではありません。');
    }

    $duid = $POST['duid'];
    $user_id = $_SESSION['login']['user_id'];
    $tenant_id = $_SESSION['login']['tenant_id'];

    // 過去に操作した空調デバイスIDをウィジェット設定から取得し、情報をデータベースより取得。
    $deviceData = [];
    $d_row = $sgMDL->GetDeviceTblByDeviceUniqID($duid);
    $deviceData = $d_row;

    if($duid == "" || !$d_row){
        $dom = <<<EOM
            <div class="control-area no-result">
                <div class="pt10 pb10">表示可能な端末がありません。
                    <button class="devcon_btn" data-toggle="modal" data-target="#modal-deviceselect-aircon">他の端末を選ぶ</button>
                </div>
            </div>
        EOM;
        $ret = [
            'state' => 'success',
            'html' => $dom,
        ];
        header('Content-Type: application/json; charset=utf-8', true);
        echo json_encode($ret);
        exit;
    }

    $u_row = $sapMDL->GetUserInfo($user_id);
    if(!$u_row) throw new Exception('ユーザー情報の読み込みが失敗しました。');
    $device_auth = explode(",", $u_row['device_authorize']);

    $AllDeviceList = $sgMDL->GetDeviceTblByTenantIDControlable($tenant_id, $device_auth);
    if(!in_array($duid, $device_auth)){
        $dom = <<<EOM
            <div class="control-area no-result">
                <div class="pt10 pb10">操作可能な端末ではありません。
                    <button class="devcon_btn" data-toggle="modal" data-target="#modal-deviceselect-aircon">他の端末を選ぶ</button>
                </div>
            </div>
        EOM;
        $ret = [
            'state' => 'success',
            'html' => $dom,
        ];
        header('Content-Type: application/json; charset=utf-8', true);
        echo json_encode($ret);
        exit;
    }

    //TODO 第三者APIからデバイスの状態を取得
    require(SIGNAGE_ROOT."api.php");
    $API = new Api($tenant_id);
    $res = $API->GetTenantName();
    $sitename = $res->Data->{'General.SiteList'}[0];
    $dinfo = $API->GetDeviceStatus($sitename, $deviceData['type'], $deviceData['device_id']);
    $dd = $dinfo->Data;
    $deviceData['running'] = (isset($dd->{'Device.Status.RunningControl'}))?$dd->{'Device.Status.RunningControl'}:1;
    $deviceData['temp'] = (isset($dd->{'Device.Status.TempControl'}))?$dd->{'Device.Status.TempControl'}:27.5;
    $deviceData['level'] = (isset($dd->{'Device.Status.AirVolumeControl'}))?$dd->{'Device.Status.AirVolumeControl'}:4;
    $deviceData['max'] = (isset($dd->{'Device.Status.MaxTemp'}))?$dd->{'Device.Status.MaxTemp'}:30.0;
    $deviceData['min'] = (isset($dd->{'Device.Status.MinTemp'}))?$dd->{'Device.Status.MinTemp'}:15.0;
    $deviceData['suptemp'] = (isset($dd->{'Device.Status.SupplyAirTempSetting'}))?$dd->{'Device.Status.SupplyAirTempSetting'}:27.5;

    //一括操作
    $deviceData['handc'] = (isset($dd->{'Device.Status.HeatingAndCoolingControl'}))?$dd->{'Device.Status.HeatingAndCoolingControl'}:1;
    $widget = "AirconDeviceControllWidget";

    $levelarr = [
        [
            'id'=>'aLevelLow',
            'label'=>'弱',
            'value'=>1,
        ],
        [
            'id'=>'aLevelMiddle',
            'label'=>'中',
            'value'=>2,
        ],
        [
            'id'=>'aLevelHigh',
            'label'=>'強',
            'value'=>3,
        ],
        [
            'id'=>'aLevelAuto',
            'label'=>'自動',
            'value'=>4,
        ],
    ];

    if(!empty($deviceData)){
        $runninged = ($deviceData['running'] == 1)?"checked":"";
        $onoff = ($deviceData['running'] == 1)?"ON":"OFF";
        $cw_type = ($deviceData['handc'] == 0)?"暖房":"冷房";
        $cw_stt = ($deviceData['handc'] == 1)?"checked":"";

        switch($deviceData['type']){
            case DEVICE_TYPE_AIRCON_DCU:
            case DEVICE_TYPE_AIRCON_FCU:
                $leveldom = "";
                foreach($levelarr as $laK => $laV){
                    $checked = ($deviceData['level'] == $laV['value'])?'checked':'';
                    $leveldom .= <<<EOM
                        <div class="radiobuttonwrap">
                            <input id="{$laV['id']}" class="radiobutton" name="level" type="radio" value="{$laV['value']}" {$checked}/>
                            <label class="radiolabel" for="{$laV['id']}">{$laV['label']}</label>
                        </div>
                    EOM;
                }
                $dom = <<<EOM
                    <div class="control-area" data-type="{$deviceData['type']}">
                        <form onsubmit="return false;">
                            <div class="device-control-title">
                                空調設定 - <span class="title-devicename">{$deviceData['name']}</span>
                                <button class="devcon_btn" data-toggle="modal" data-target="#modal-deviceselect-aircon">他の端末を選ぶ</button>
                            </div>
                            <div class="device-wrap-box air-device-wrap">
                                <input type="hidden" id="ControllDeviceId_{$deviceData['du_id']}" />
                                    <span class="svg-wrap device-icon">
                                        <svg class="img-fluid wh100px">
                                            <use xlink:href="./widget/{$widget}/img/air.svg#Air"></use>
                                        </svg>
                                    </span>
                                <div class="control-box">
                                    <input type="hidden" name="init_powerstatus" value="on" />
                                    <input type="hidden" name="init_temp" value="{$deviceData['temp']}" />
                                    <input type="hidden" name="init_level" value="{$deviceData['level']}" />
                                    <div class="d-flex justify-content-center justify-content-lg-left">
                                        <div class="control-group devicecon-powerswitch d-flex">
                                            <p class="device-state w100">電源：<span>{$onoff}</span></p>
                                            <div class="custom-control custom-switch">
                                                <input type="checkbox" class="custom-control-input" id="AirDeviceSetting_{$deviceData['type']}" name="powerstatus" {$runninged}>
                                                <label class="custom-control-label" for="AirDeviceSetting_{$deviceData['type']}"></label>
                                            </div>
                                        </div>
                                        <div class="control-group devicecon-updown d-flex">
                                            <p class="device-state w100">温度：</p>
                                            <div class="device-updown">
                                                <span class="control-arrow down-arrow">◀</span>
                                                <span class="box-updown"><input type="number" name="temp" class="no-style-input" value="{$deviceData['temp']}" step="0.5" max="{$deviceData['max']}" min="{$deviceData['min']}" readonly/></span>
                                                <span class="control-arrow up-arrow">▶</span>
                                            </div>
                                        </div>
                                        <div class="control-group devicecon-level d-flex">
                                            <p class="device-state w100">風量：</p>
                                            <div class="device-btn">
                                                <div class="radiobox">
                                                    {$leveldom}
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="device-control-footer">
                                <button data-duid="{$deviceData['du_id']}" class="devcon_btn device-setting-submit">
                                    <div class="device-setting-update d-none">
                                        <div class="loader_inner">
                                            <div class="circle_loader">Loading...</div>
                                        </div>
                                    </div>
                                    <span>設定</span>
                                </button>
                            </div>
                        </form>
                    </div>
                EOM;
                break;

            case DEVICE_TYPE_AIRCON_AHU:
                $dom = <<<EOM
                    <div class="control-area" data-type="{$deviceData['type']}">
                        <form onsubmit="return false;">
                            <div class="device-control-title">
                                空調設定 - <span class="title-devicename">{$deviceData['name']}</span>
                                <button class="devcon_btn" data-toggle="modal" data-target="#modal-deviceselect-aircon">他の端末を選ぶ</button>
                            </div>
                            <div class="device-wrap-box air-device-wrap">
                                <input type="hidden" id="ControllDeviceId_{$deviceData['du_id']}" />
                                <span class="svg-wrap device-icon">
                                    <svg class="img-fluid wh100px">
                                        <use xlink:href="./widget/{$widget}/img/air.svg#Air"></use>
                                    </svg>
                                </span>
                                <div class="control-box">
                                    <input type="hidden" name="init_powerstatus" value="on" />
                                    <input type="hidden" name="init_temp" value="{$deviceData['temp']}" />
                                    <input type="hidden" name="init_level" value="{$deviceData['level']}" />
                                    <div class="d-flex justify-content-center justify-content-md-left">
                                        <div class="control-group devicecon-powerswitch d-flex">
                                            <p class="device-state w100">電源：<span>{$onoff}</span></p>
                                            <div class="custom-control custom-switch">
                                                <input type="checkbox" class="custom-control-input" id="AirDeviceSetting_{$deviceData['type']}" name="powerstatus" {$runninged}>
                                                <label class="custom-control-label" for="AirDeviceSetting_{$deviceData['type']}"></label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="device-control-footer">
                                <button data-duid="{$deviceData['du_id']}" class="devcon_btn device-setting-submit">
                                    <div class="device-setting-update d-none">
                                        <div class="loader_inner">
                                            <div class="circle_loader">Loading...</div>
                                        </div>
                                    </div>
                                    <span>設定</span>
                                </button>
                            </div>
                        </form>
                    </div>
                EOM;
                break;

            case DEVICE_TYPE_AIRCON_OHU:
                $dom = <<<EOM
                    <div class="control-area" data-type="{$deviceData['type']}">
                        <form onsubmit="return false;">
                            <div class="device-control-title">
                                空調設定 - <span class="title-devicename">{$deviceData['name']}</span>
                                <button class="devcon_btn" data-toggle="modal" data-target="#modal-deviceselect-aircon">他の端末を選ぶ</button>
                            </div>
                            <div class="device-wrap-box air-device-wrap">
                                <input type="hidden" id="ControllDeviceId_{$deviceData['du_id']}" />
                                <span class="svg-wrap device-icon">
                                    <svg class="img-fluid wh100px">
                                        <use xlink:href="./widget/{$widget}/img/air.svg#Air"></use>
                                    </svg>
                                </span>
                                <div class="control-box">
                                    <input type="hidden" name="init_powerstatus" value="on" />
                                    <input type="hidden" name="init_temp" value="{$deviceData['temp']}" />
                                    <input type="hidden" name="init_level" value="{$deviceData['level']}" />
                                    <div class="d-flex justify-content-center justify-content-lg-left">
                                        <div class="control-group devicecon-powerswitch d-flex">
                                            <p class="device-state w100">電源：<span>{$onoff}</span></p>
                                            <div class="custom-control custom-switch">
                                                <input type="checkbox" class="custom-control-input" id="AirDeviceSetting_{$deviceData['type']}" name="powerstatus" {$runninged}>
                                                <label class="custom-control-label" for="AirDeviceSetting_{$deviceData['type']}"></label>
                                            </div>
                                        </div>
                                        <div class="control-group devicecon-updown d-flex">
                                            <p class="device-state w100">温度：</p>
                                            <div class="device-updown">
                                                <span class="control-arrow down-arrow">◀</span>
                                                <span class="box-updown"><input type="number" name="suptemp" class="no-style-input" value="{$deviceData['suptemp']}" step="0.5" max="{$deviceData['max']}" min="{$deviceData['min']}" readonly/></span>
                                                <span class="control-arrow up-arrow">▶</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="device-control-footer">
                                <button data-duid="{$deviceData['du_id']}" class="devcon_btn device-setting-submit">
                                    <div class="device-setting-update d-none">
                                        <div class="loader_inner">
                                            <div class="circle_loader">Loading...</div>
                                        </div>
                                    </div>
                                    <span>設定</span>
                                </button>
                            </div>
                        </form>
                    </div>
                EOM;
                break;

            case DEVICE_TYPE_AIRCON_BULK_FCU:
                $leveldom = "";
                foreach($levelarr as $laK => $laV){
                    $checked = ($deviceData['level'] == $laV['value'])?'checked':'';
                    $leveldom .= <<<EOM
                        <div class="radiobuttonwrap">
                            <input id="{$laV['id']}" class="radiobutton" name="level" type="radio" value="{$laV['value']}" {$checked}/>
                            <label class="radiolabel" for="{$laV['id']}">{$laV['label']}</label>
                        </div>
                    EOM;
                }
                $dom = <<<EOM
                    <div class="control-area" data-type="{$deviceData['type']}">
                        <form onsubmit="return false;">
                            <div class="device-control-title">
                                空調設定 - <span class="title-devicename">{$deviceData['name']}</span>
                                <button class="devcon_btn" data-toggle="modal" data-target="#modal-deviceselect-aircon">他の端末を選ぶ</button>
                            </div>
                            <div class="device-wrap-box air-device-wrap">
                                <input type="hidden" id="ControllDeviceId_{$deviceData['du_id']}" />
                                <span class="svg-wrap device-icon">
                                    <svg class="img-fluid wh100px">
                                        <use xlink:href="./widget/{$widget}/img/air.svg#Air"></use>
                                    </svg>
                                </span>
                                <div class="control-box">
                                    <input type="hidden" name="init_powerstatus" value="on" />
                                    <input type="hidden" name="init_cwstatus" value="hot" />
                                    <input type="hidden" name="init_temp" value="{$deviceData['temp']}" />
                                    <input type="hidden" name="init_level" value="{$deviceData['level']}" />
                                    <div class="d-flex justify-content-center justify-content-lg-left">
                                        <div class="control-group devicecon-powerswitch d-flex col-3 plr0">
                                            <p class="device-state w100">電源：<span>{$onoff}</span></p>
                                            <div class="custom-control custom-switch">
                                                <input type="checkbox" class="custom-control-input" id="AirDeviceSetting_{$deviceData['type']}" name="powerstatus" {$runninged}>
                                                <label class="custom-control-label" for="AirDeviceSetting_{$deviceData['type']}"></label>
                                            </div>
                                        </div>

                                        <div class="control-group devicecon-cwswitch d-flex col-3 plr0">
                                            <p class="device-state w100">冷暖切替：<span>{$cw_type}</span></p>
                                            <div class="custom-control custom-switch">
                                                <input type="checkbox" class="custom-control-input" id="AirDeviceSettingBulk_{$deviceData['type']}" name="cwswitch" {$cw_stt}>
                                                <label class="custom-control-label" for="AirDeviceSettingBulk_{$deviceData['type']}"></label>
                                            </div>
                                        </div>
                                        <div class="control-group devicecon-updown d-flex col-6 plr0">
                                            <p class="device-state w100">温度：</p>
                                            <div class="device-updown">
                                                <span class="control-arrow down-arrow">◀</span>
                                                <span class="box-updown"><input type="number" name="temp" class="no-style-input" value="{$deviceData['temp']}" step="0.5" max="{$deviceData['max']}" min="{$deviceData['min']}" readonly/></span>
                                                <span class="control-arrow up-arrow">▶</span>
                                            </div>
                                        </div>
                                        <div class="control-group devicecon-level d-flex">
                                            <p class="device-state w100">風量：</p>
                                            <div class="device-btn">
                                                <div class="radiobox">
                                                    {$leveldom}
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="device-control-footer">
                                <button data-duid="{$deviceData['du_id']}" class="devcon_btn device-setting-submit">
                                    <div class="device-setting-update d-none">
                                        <div class="loader_inner">
                                            <div class="circle_loader">Loading...</div>
                                        </div>
                                    </div>
                                    <span>設定</span>
                                </button>
                            </div>
                        </form>
                    </div>
                EOM;
                break;

            default:
                $dom = <<<EOM
                    <div class="control-area no-result">
                        <div class="pt10 pb10">最後に操作した端末は存在しません。
                            <button class="devcon_btn" data-toggle="modal" data-target="#modal-deviceselect-aircon">他の端末を選ぶ</button>
                        </div>
                    </div>
                EOM;
                break;
        }
    }else{
        $dom = <<<EOM
            <div class="control-area no-result">
                <div class="pt10 pb10">最後に操作した端末は存在しません。
                    <button class="devcon_btn" data-toggle="modal" data-target="#modal-deviceselect-aircon">他の端末を選ぶ</button>
                </div>
            </div>
        EOM;
    }
    $ret = [
        'state' => 'success',
        'html' => $dom,
    ];

    $log->info('Successful aircon device status load.',
        array('file' => __FILE__, 'user_id' => $user_id)
    );

    header('Content-Type: application/json; charset=utf-8', true);
    echo json_encode($ret);
}catch(Exception $e){
    $ret = [
        'state' => 'error',
        'msg' => $e->getMessage(),
    ];
    $mes = GetMsgEncode($e->getMessage());

    // 空調デバイス情報取得失敗時ログ
    $log->info($e);
    $log->info('Failed to aircon device status load.',
        array(
            'file' => __FILE__,
            'user_id' => $user_id,
            'message' => $e->getMessage()
        )
    );

    header('Content-Type: application/json; charset=utf-8', true);
    echo json_encode($ret);
}
?>
