<?php
require_once("../../core/construct.php");
require_once(CORE_PATH."functions.php");
require_once(CORE_PATH."session_check.php");
require_once(SIGNAGE_ROOT."api.php");
require_once(SUPER_APPLI_ROOT."model/model.php");
require_once(__DIR__ . '/../../util/utils.php');

try{
    if(!isset($_SERVER['HTTP_X_REQUESTED_WITH']) || strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) !== 'xmlhttprequest') {
        throw new Exception('HTTP通信に失敗しました。');
    }
    $sapMDL = new sappModel($sdb, $link);
    // テキストファイルからデバイスタイプ取得
    $filename =  __DIR__.'/../../../contents/devicetype_'.$_ENV["SITE_NAME"].'.txt';
    $text_open = fopen($filename, 'r');
    $read_text = fread($text_open, filesize($filename));
    $text_split = preg_split ('/^\d*_/',$read_text);
    fclose($text_open);
    $json_data = json_decode($text_split[0], true);
    $res_device_type = $json_data['res_device_type'];
    if(!$res_device_type){
        throw new Exception("デバイスタイプの取得に失敗しました。");
    }
    $POST = filterPost();
    $Dom = "";
    // 警報件数取得
    $alarm_number = 0;
    $json_count = count($res_device_type);
    $Dom .= '<div class="wrapper">';
    $Dom .= '<table id="AlarmListTables">';
    $Dom .= '<thead>';
    $Dom .= '<tr>';
    $Dom .= '<th>デバイス名</th>';
    $Dom .= '<th>デバイスタイプ</th>';
    $Dom .= '<th>ファンクション名</th>';
    $Dom .= '<th>警報状態</th>';
    $Dom .= '<th data-lockedorder="desc">警報レベル</th>';
    $Dom .= '</tr>';
    $Dom .= '</thead>';
    $Dom .= '<tbody>';

    // デバイスタイプごとにループ
    for($device_count = 0; $device_count < $json_count; $device_count++){
        // テキストファイルからデバイスタイプ情報取得
        $device_filename =  __DIR__.'/../../../contents/devicedata_'.$res_device_type[$device_count].'_'.$_ENV["SITE_NAME"].'.txt';
        $device_text_open = fopen($device_filename, 'r');
        $read_device_text = fread($device_text_open, filesize($device_filename));
        $device_text_split = preg_split ('/^\d*_/',$read_device_text);
        fclose($device_text_open);
        $text_data = json_decode($device_text_split[0], true);
        $alarm_status = $text_data["res_device_data"];
        if(!$alarm_status){
            throw new Exception("デバイス情報の取得に失敗しました。");
        }
        // SQL
        $db_device_data = $sapMDL->GetAlarmDeviceType($res_device_type[$device_count]);
        $db_device_data_list = [];
        if($db_device_data){
            foreach($db_device_data as $db_device_data_key => $db_device_data_value){
                $db_device_data_list[$db_device_data_value['id']]['id'] = $db_device_data_value['id'];
                // 例)AHU
                $db_device_data_list[$db_device_data_value['id']]['device_type'] = $db_device_data_value['device_type'];
                // 例)Device.Status.RunningControl
                $db_device_data_list[$db_device_data_value['id']]['device_function'] = $db_device_data_value['device_function'];
                // 例)運転状態
                $db_device_data_list[$db_device_data_value['id']]['description'] = $db_device_data_value['description'];
                // 例)JSON_OBJECT("0","OFF","1","ON")
                $db_device_data_list[$db_device_data_value['id']]['device_values'] = $db_device_data_value['device_values'];
            };
        };
        if(!$db_device_data_list){
            throw new Exception("DBデータの取得に失敗しました。");
        }
        $alarm_info_sql = $sapMDL->GetAlarmInfoDevice();
        $db_device_data_value = [];
        if($alarm_info_sql){
            foreach($alarm_info_sql as $alarm_info_key => $alarm_info_value){
                $db_device_data_value[$alarm_info_value['id']]['devicefunctiontbl_id'] = $alarm_info_value['devicefunctiontbl_id'];
                $db_device_data_value[$alarm_info_value['id']]['device_id'] = $alarm_info_value['device_id'];
                $db_device_data_value[$alarm_info_value['id']]['alarm_type'] = $alarm_info_value['alarm_type'];
            };
        };
        if(!$db_device_data_value){
            throw new Exception("DBデータの取得に失敗しました。");
        }
        // Dx-Coreからステータス情報取得
        $alarm_count = count($alarm_status);
        // DX-Coreで取得したデータの数ループ
        for($alarm_counter = 0; $alarm_counter < $alarm_count; $alarm_counter++){
            $alarm_json = (array)$alarm_status[$alarm_counter];
            $alarm_json_count = count($alarm_json);
            $alarm_json_key = array_keys($alarm_json);
            $alarm_json_value = array_values($alarm_json);
            // １つの機器のファンクションの数ループ
            foreach($db_device_data_list as $db_device_data_list_key => $db_device_data_list_value){
                foreach($db_device_data_value as $db_device_data_value_list_key => $db_device_data_value_list_val){
                    if((intval($db_device_data_value_list_val['device_id']) === $alarm_json['Device.Info.Id'] || $db_device_data_value_list_val['device_id'] === '0') && ($db_device_data_list_value['device_type'] === $alarm_json['Device.Info.Type'] && $db_device_data_list_value['id'] === $db_device_data_value_list_val['devicefunctiontbl_id']) && ($alarm_json[$db_device_data_list_value['device_function']] === 1)){
                        if($db_device_data_value_list_val['alarm_type'] === '2'){
                            $json_df = json_decode($db_device_data_list_value['device_values'], true);
                            $alarm_status_value = array_values($json_df);
                            $Dom .= '<tr data-device.info.id="'.$db_device_data_value_list_val['device_id'].'" data-devicename="'.$alarm_json['Device.Info.Description'].'" data-devicetype="'.$db_device_data_list_value['device_type'].'" data-function="'.$db_device_data_list_value['description'].'" data-values="'.$alarm_status_value[1].'" data-alarm_type="'.$db_device_data_value_list_val['alarm_type'].'"  data-toggle="modal" data-target="#modal-keihouDeviceList_dl">';
                            $alarm_number = $alarm_number + 1;
                            $Dom .= '<td>'.$alarm_json['Device.Info.Description'].'</td>';
                            $Dom .= '<td>'.$db_device_data_list_value['device_type'].'</td>';
                            $Dom .= '<td>'.$db_device_data_list_value['description'].'</td>';
                            // $Dom .= '<td>ON</td>';
                            $Dom .= '<td>'.$alarm_status_value[1].'</td>';
                            $Dom .= '<td data-order="3">重警報</td>';
                            $Dom .= '</tr>';
                        } elseif($db_device_data_value_list_val['alarm_type'] === '1'){
                            $json_df = json_decode($db_device_data_list_value['device_values'], true);
                            $alarm_status_value = array_values($json_df);
                            $Dom .= '<tr data-device.info.id="'.$db_device_data_value_list_val['device_id'].'" data-devicename="'.$alarm_json['Device.Info.Description'].'" data-devicetype="'.$db_device_data_list_value['device_type'].'" data-function="'.$db_device_data_list_value['description'].'" data-values="'.$alarm_status_value[1].'" data-alarm_type="'.$db_device_data_value_list_val['alarm_type'].'"  data-toggle="modal" data-target="#modal-keihouDeviceList_dl">';
                            $alarm_number = $alarm_number + 1;
                            $Dom .= '<td>'.$alarm_json['Device.Info.Description'].'</td>';
                            $Dom .= '<td>'.$db_device_data_list_value['device_type'].'</td>';
                            $Dom .= '<td>'.$db_device_data_list_value['description'].'</td>';
                            $Dom .= '<td>'.$alarm_status_value[1].'</td>';
                            $Dom .= '<td data-order="2">中警報</td>';
                            $Dom .= '</tr>';
                        } elseif($db_device_data_value_list_val['alarm_type'] === '0'){
                            $json_df = json_decode($db_device_data_list_value['device_values'], true);
                            $alarm_status_value = array_values($json_df);
                            $Dom .= '<tr data-device.info.id="'.$db_device_data_value_list_val['device_id'].'" data-devicename="'.$alarm_json['Device.Info.Description'].'" data-devicetype="'.$db_device_data_list_value['device_type'].'" data-function="'.$db_device_data_list_value['description'].'" data-values="'.$alarm_status_value[1].'" data-alarm_type="'.$db_device_data_value_list_val['alarm_type'].'"  data-toggle="modal" data-target="#modal-keihouDeviceList_dl">';
                            $alarm_number = $alarm_number + 1;
                            $Dom .= '<td>'.$alarm_json['Device.Info.Description'].'</td>';
                            $Dom .= '<td>'.$db_device_data_list_value['device_type'].'</td>';
                            $Dom .= '<td>'.$db_device_data_list_value['description'].'</td>';
                            $Dom .= '<td>'.$alarm_status_value[1].'</td>';
                            $Dom .= '<td data-order="1">軽警報</td>';
                            $Dom .= '</tr>';
                        };
                        break;
                    };
                };
            };
        };
    };

    $Dom .= '</tbody>';
    $Dom .= '</table>';
    $Dom .= '<div class="alarm_keihou" style="float: right">';
    // ウィンドウサイズ
    $window_size = $POST['width'];
    if($window_size < 500){
        $Dom .= '<p style="width:107px;position:relative;left:19px;">デバイス警報　</p>';
        $Dom .= '<p style="width:107px;position:relative;left:9px;"><span>'.$alarm_number.'</span>件発生中</p>';
    }elseif($window_size > 499){
    $Dom .= '<p>デバイス警報　<span>'.$alarm_number.'</span>件発生中</p>';
    }
    $Dom .= '</div>';
    $Dom .= '</div>';
    $ret = [
        'state' => 'success',
        'alarm_device' => $Dom,
        'window_size' => $window_size
    ];
    $log->info('Successful widget loaded.', array('file' => __FILE__, 'user_id' => $_SESSION['login']['user_id']));
    header('Content-Type: application/json; charset=utf-8', true);
    echo json_encode($ret);
}catch(Exception $e){
    $ret = [
        'state' => 'error',
        'msg' => $e->getMessage()
    ];
    $log->error($e);
    $log->error('Failed widget loaded.', array('file' => __FILE__, 'user_id' => $_SESSION['login']['user_id'], 'message' => $e->getMessage()));
    header('Content-Type: application/json; charset=utf-8', true);
    echo json_encode($ret);
};
?>
