$(function(){
    // ページ読み込み時0.5秒後に描画
    setTimeout(function(){
        getAlarmStatusList();
    },500);
    setInterval(function(){
        var object = document.getElementsByName("AlarmListTables_length")[0];
        var selectIndex = object.selectedIndex;
        var selectText  = object.options[selectIndex].text;
        if(isNaN(selectText) === true){
            selectText = -1;
        };
        var index = $('.paginate_button.page-item.active').index('ul.pagination li');
        let indexNumber = document.querySelectorAll('li :first-child')[index].textContent;
        get60sAiarmInfo(selectText, indexNumber);
    },60000);
    var template = null;

    $('#modal-keihouDeviceList_dl').on('show.bs.modal', function (event) {
        // モーダル初期化
        if (template == null) {
            template = $(this).html();
        } else {
            $(this).html(template);
        };
        var device_id = $(event.relatedTarget).data('device.info.id');
        $(this).find('.devicetype-wrap').removeClass('d-none');
        $(this).find('#DeviceId').val(device_id);
        // デバイス名
        var deviceName = $(event.relatedTarget).data("devicename");
        $(this).find('#ModaKeihoulWidgetDLTitle').text(deviceName);
        // ahu
        var deviceType = $(event.relatedTarget).data("devicetype");
        $(this).find('.alarm_devicetype_p').text(deviceType);
        // 警報
        var deviceFunction = $(event.relatedTarget).data("function");
        $(this).find('.alarm_function_p').text(deviceFunction);
        // ON
        var deviceValue = $(event.relatedTarget).data("values");
        $(this).find('.alarm_values_p').text(deviceValue);
        // 中警報
        var deviceAlarmValue = $(event.relatedTarget).data("alarm_type");
        if(deviceAlarmValue == 0){
            var deviceAlarm = '軽警報';
        }else if(deviceAlarmValue === 1){
            var deviceAlarm = '中警報';
        }else if(deviceAlarmValue == 2){
            var deviceAlarm = '重警報';
        };
        $(this).find('.alarm_type_p').text(deviceAlarm);
    });
});

function getAlarmStatusList(){
    widthSize = new Object();
    widthSize.width = $(window).width();
    $.ajax({
        type: "POST",
        url: "./widget/AlarmListWidget/get_ajax.php",
        data: widthSize,
        timeout: 100000
    }).done(function(response, textStatus, jqXHR){
        if(response.state == 'success'){
            // 成功時処理
            $('#AlarmListWidget .widget-loading-area').html(response.alarm_device);
            $('#AlarmListWidget .widget-loading-area').removeClass('d-none');
            $('#AlarmListWidget .widget-body .loader_wrap').addClass('d-none');
            $("#AlarmListTables").DataTable({
                // 日本語化
                language: {
                    url: 'widget/AlarmListWidget/DataTables-1.10.24/lang/ja.json'
                },
                // 検索機能 無効
                searching: false,
                // ソート機能 有効
                ordering: true,
                // 初期表示 警報レベル降順
                order: [ [ 4, "desc" ] ],
                // 情報表示 無効
                info: false,
                // ページング機能 有効
                paging: true,
                // 初期表示件数
                pageLength: 10,
                // 件数表示 有効
                lengthMenu: [ [10, 25, 50, 100,-1], [10, 25, 50, 100, "全"]],//表示件数メニュー
                // 横スクロール 有効
                scrollX: true,
                // 縦スクロール 有効
                scrollY: 435,
                // オプションレイアウト
                "dom": '<"top"fli>rt<"bottom"p><"clear">'
            });
        }else{
            alert('警報リストの読み込みに失敗しました。');
            $('#AlarmListWidget .widget-loading-area').html('<div class="ajax_failed">'+response.msg+'</div>');
            $('#AlarmListWidget .widget-loading-area').removeClass('d-none');
            $('#AlarmListWidget .widget-body .loader_wrap').addClass('d-none');
        };
    }).fail(function(XMLHttpRequest,jqXHR, textStatus, errorThrown){
        // 失敗時処理
        alert('警報リストの読み込みに失敗しました。');
        console.log(XMLHttpRequest,jqXHR, textStatus, errorThrown);
        $('#AlarmListWidget .widget-loading-area').html('<div class="ajax_failed">ウィジェットの読み込みに失敗しました。</div>');
        $('#AlarmListWidget .widget-loading-area').removeClass('d-none');
        $('#AlarmListWidget .widget-body .loader_wrap').addClass('d-none')
        return false;
    });
};

function get60sAiarmInfo(displayedResults, pageNumberValue){
    var pageNumber = Number(pageNumberValue)*Number(displayedResults)-Number(displayedResults);
    widthSize = new Object();
    widthSize.width = $(window).width();
    $.ajax({
        type: "POST",
        url: "./widget/AlarmListWidget/get_ajax.php",
        data: widthSize,
        timeout: 100000
    }).done(function(response, textStatus, jqXHR){
        if(response.state == 'success'){
            // 成功時処理
            $('#AlarmListWidget .widget-loading-area').html(response.alarm_device);
            $('#AlarmListWidget .widget-loading-area').removeClass('d-none');
            $('#AlarmListWidget .widget-body .loader_wrap').addClass('d-none');
            $("#AlarmListTables").DataTable({
                // 日本語化
                language: {
                    url: 'widget/AlarmListWidget/DataTables-1.10.24/lang/ja.json'
                },
                // 検索機能 無効
                searching: false,
                // ソート機能 有効
                ordering: true,
                // 初期表示 警報レベル降順
                order: [ [ 4, "desc" ] ],
                // 情報表示 無効
                info: false,
                // ページング機能 有効
                paging: true,
                displayStart: pageNumber,
                // 初期表示件数
                pageLength: Number(displayedResults),
                // 件数表示 有効
                lengthMenu: [ [10, 25, 50, 100,-1], [10, 25, 50, 100, "全"]],//表示件数メニュー
                // 横スクロール 有効
                scrollX: true,
                // 縦スクロール 有効
                scrollY: 435,
                // オプションレイアウト
                "dom": '<"top"fli>rt<"bottom"p><"clear">'
            });
            // $(this).addClass("active");
            // ChangeLi();
        }else{
            alert('警報リストの読み込みに失敗しました。');
            $('#AlarmListWidget .widget-loading-area').html('<div class="ajax_failed">'+response.msg+'</div>');
            $('#AlarmListWidget .widget-loading-area').removeClass('d-none');
            $('#AlarmListWidget .widget-body .loader_wrap').addClass('d-none');
        };
    }).fail(function(XMLHttpRequest,jqXHR, textStatus, errorThrown){
        // 失敗時処理
        alert('警報リストの読み込みに失敗しました。');
        console.log(XMLHttpRequest,jqXHR, textStatus, errorThrown);
        $('#AlarmListWidget .widget-loading-area').html('<div class="ajax_failed">ウィジェットの読み込みに失敗しました。</div>');
        $('#AlarmListWidget .widget-loading-area').removeClass('d-none');
        $('#AlarmListWidget .widget-body .loader_wrap').addClass('d-none')
        return false;
    });
};
