<?php

require("../../core/construct.php");
require(CORE_PATH."functions.php");
require_once(CORE_PATH."session_check.php");
require_once(__DIR__ . "/../../util/utils.php");
require(SUPER_APPLI_ROOT."model/model.php");
$sapMDL = new sappModel($sdb, $link);

try{

    if(!isset($_SERVER['HTTP_X_REQUESTED_WITH']) || strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) !== 'xmlhttprequest') {
        throw new Exception('接続が安全ではありません。');
    }

    $POST = filterPost();

    $tenant= $POST['tenant'];
    $tn_row = $sapMDL->GetTenantData($tenant);

    if($tn_row){
        $prefecture = 'TOKYO';
        $country = 'jp';
        $city = 'KOTO-KU';
        $lat = $tn_row['lat'];
        $lon = $tn_row['lon'];
    }

    $filename =  CONTENTS_PATH.'weather_'.$tenant.'.txt';
    $fp = fopen($filename, 'a+');
    $contents = fread($fp, filesize($filename));
    $ret = preg_split ('/^\d*_/',$contents);
    $flag = fclose($fp);

    $rawData = $ret[1];
//     $rawData = '{"coord":{"lon":139.6917,"lat":35.6895},"weather":[{"id":803,"main":"Clouds","description":"broken clouds","icon":"04d"}],"base":"stations","main":{"temp":291.44,"feels_like":291.78,"temp_min":290.15,"temp_max":292.15,"pressure":1003,"humidity":94},"visibility":6000,"wind":{"speed":4.63,"deg":210},"clouds":{"all":75},"dt":1618365644,"sys":{"type":1,"id":8077,"country":"JP","sunrise":1618344602,"sunset":1618391561},"timezone":32400,"id":1850144,"name":"Tokyo","cod":200}';

    $jsonData = json_decode($rawData);


    $weekList = [ "SUN", "MON", "TUE", "WED", "THU", "FRI", "SAT" ];
    if($jsonData){
        $temprature = (!is_null($jsonData->main->temp))?round($jsonData->main->temp - 273.15, 1):15;
//         $temprature = round($jsonData->main->temp - 273.15, 1);
        $weatherData = [
            'weather' => $jsonData->weather[0]->main,
            'weather_id' => $jsonData->weather[0]->id,
            'temp' => $temprature,
        ];


        $weather = GetWeatherForID($weatherData['weather_id']);
        $caps_w = ucfirst($weather);

        $t = new Datetime();
        if((int)$t->format("G") > 18 || 6 > (int)$t->format("G")){
            $weather .= "_n";
            $caps_w .= "_n";
        }

        $temprature = $weatherData['temp'];

        $t = new Datetime();
        $ampm = (int)$t->format("G") < 12 ? 'AM' : 'PM';

        $dom = "";

        $dom.='<div class="d-flex">';
            $dom.='<div id="cawClock" class="col-8 d-flex plr0">';
                $dom.='<div class="caw_date d-flex plr0 align-self-end">';
                    $dom.='<div class="caw_year">'.$t->format("Y").'</div>';
                    $dom.='<div class="caw_month align-self-end pr0">'.$t->format("n").'</div><div class="caw_sep align-self-end">/</div><div class="caw_day align-self-end plr0">'.$t->format("j").'</div><div class="caw_week align-self-end plr0">'.$weekList[$t->format("w")].'</div>';
                $dom.='</div>';
                $dom.='<div class="caw_time d-flex plr0 align-self-end">';
                    $dom.='<div class="caw_hour pr0">'.$t->format("G").'</div><div class="caw_coron plr0">:</div><div class="caw_minute pl0">'.$t->format("i").'</div>';
                    $dom.='<div class="caw_ampm align-self-end">'.$ampm.'</div>';
                $dom.='</div>';
            $dom.='</div>';
            $dom.='<div id="cawWeather" class="col-4 plr0 d-flex align-self-end">';
                $dom.='<div class="caw_wt_icon svg-wrap plr0">';
                    $dom.='<svg class="img-fluid">';
                    $dom.='<use xlink:href="'.BASE_URL.'widget/ClockAndWeatherWidget/img/'.$weather.'.svg#'.$caps_w.'"></use>';
                    $dom.='</svg>';
                $dom.='</div>';
                $dom.='<div class="plr0 align-self-end">';
                    $dom.='<div class="caw_pref">'.h($prefecture).'</div>';
                    $dom.='<div class="caw_temp"><span>'.$temprature.'</span>°</div>';
                $dom.='</div>';
            $dom.='</div>';
        $dom.='</div>';

    }
    // echo $dom;

    $ret = [
        'state' => 'success',
        'html' => $dom,
    ];

    $log->info('Successful clock and weather information load.',
        array('file' => __FILE__, 'user_id' => $_SESSION['login']['user_id'])
    );

    header('Content-Type: application/json; charset=utf-8', true);
    echo json_encode($ret);


}catch(Exception $e){

    $ret = [
        'state' => 'error',
        'msg' => $e->getMessage(),
    ];

    $mes = GetMsgEncode($e->getMessage());

    $log->info($e);
    $log->info('Failed to clock and weather information load.',
        array(
            'file' => __FILE__,
            'user_id' => $_SESSION['login']['user_id'],
            'message' => $e->getMessage()
        )
    );

    header('Content-Type: application/json; charset=utf-8', true);
    echo json_encode($ret);
}
?>