/**
 * リアルタイム時刻表示
 */

$(function(){
    showClock();
    //1秒ごとに実行
    setInterval(showClock,1000);
});

function showClock(){
    var id= "#cawClock";
    var nowTime = new Date(); //  現在日時を得る
    var nowYear = nowTime.getFullYear(); // 年を抜き出す
    var nowMonth = nowTime.getMonth(); // 月を抜き出す
    var nowDate = nowTime.getDate(); // 日を抜き出す
    var nowHour = nowTime.getHours(); // 時を抜き出す
    var nowMin  = nowTime.getMinutes(); // 分を抜き出す
    var nowSec  = nowTime.getSeconds(); // 秒を抜き出す
    var dayOfWeek = nowTime.getDay() ;  // 曜日(数値)
    var dayOfWeekStr = [ "SUN", "MON", "TUE", "WED", "THU", "FRI", "SAT" ][dayOfWeek] ;

    // 午前か午後を判定
    var ampm = nowHour < 12 ? 'AM' : 'PM';

    nowMonth++;

    $(id).find('.caw_coron').fadeOut(50,function(){$(this).fadeIn(500)});

    $(id).find('.caw_year').text(zeroPadding(nowYear,4));
//  $(id).find('.caw_month').text(zeroPadding(nowMonth,2));
//  $(id).find('.caw_day').text(zeroPadding(nowDate,2));
    $(id).find('.caw_month').text(nowMonth);
    $(id).find('.caw_day').text(nowDate);
    $(id).find('.caw_hour').text(zeroPadding(nowHour,2));
    $(id).find('.caw_minute').text(zeroPadding(nowMin,2));
    $(id).find('.caw_week').text(dayOfWeekStr);
    $(id).find('.caw_ampm').text(ampm);
//  $(id).find('.ndt_seconds').text(zeroPadding(nowSec,2));
}

function zeroPadding(num,length){
    return ('0000000000' + num).slice(-length);
}
