<?php

require("../../core/construct.php");
require_once(__DIR__ . "/../../util/utils.php");

try{

    require(CORE_PATH."functions.php");
    require(CORE_PATH."session_check.php");

    require(SIGNAGE_ROOT."model/model.php");
    $sgMDL = new sngModel($sdb, $link);

    require(SUPER_APPLI_ROOT."model/model.php");
    $sapMDL = new sappModel($sdb, $link);

    require(ADMIN_ROOT."model/model.php");
    $admMDL = new admModel($sdb, $link);


    if(!isset($_SERVER['HTTP_X_REQUESTED_WITH']) || strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) !== 'xmlhttprequest') {
        throw new Exception('not ajax');
    }

    $POST = filterPost();

    $user_id = $_SESSION['login']['user_id'];
    $tenant = $_SESSION['login']['tenant_id'];
    $f_id = $POST['f_id'];

    $f_row = $admMDL->GetFieldData($f_id);
    if(!$f_row) throw new Exception('エリアが登録されていません。');

    $u_row = $sapMDL->GetUserInfo($user_id);
    if(!$u_row) throw new Exception('ユーザー情報の読み込みが失敗しました。');

    $device_auth = explode(",", $u_row['device_authorize']);

    $f_num = '9F'; //TODO
    $f_name = $f_row['field_name'];


//     $deviceDataList = [];
//     $d_row = $sgMDL->GetDeviceTblByFieldID($f_id);
//     if($d_row){
//         foreach($d_row as $dK => $dV){
//             $deviceDataList[$dV['num']] = $dV;
//             $getDeviceIdList[] = $dV['num'];
//         }
//     }


    //TODO 第三者APIから取得可能なデバイスのみ表示する



    $getDeviceIdList = [];
    $deviceDataList = [];

    //操作権限のあるデバイスのみ表示する
    $d_row = $sgMDL->GetDeviceTblByFieldIDControlable($f_id, $device_auth);

    if($d_row){
        foreach($d_row as $dK => $dV){
            if(in_array($dV['du_id'], $device_auth)){
                $deviceDataList[$dV['du_id']] = $dV;
                $getDeviceIdList[] = $dV['du_id'];
            }
        }
    }


    $widget_name = "CongestionMapConferenceWidget";
//バッファよりデバイスのログデータの取得
    $t = new Datetime();
    $timestr = $t->format("Ym");
    $filename =  CONTENTS_PATH.'devicedata_'.$tenant.'_'.$timestr.'.txt';
    $fp = fopen($filename, 'a+');
    $cgtData = [];

    //一週間前までのログのみ取得
    $wt = new Datetime();
    $wt->modify("- 7 days");

    if ($fp){
        while ($fp && !feof($fp)) {
            $line = fgets($fp);
            if($line){

                $j_line = json_decode($line, True);
                if($wt->getTimestamp() > $j_line['timestamp']) continue;
                $cgtData[] = $j_line;
            }
        }
    }

    $avgData = [];//平均混雑率

    $tmpData = [];
    $CheckTime = [];
    $todayData = [];
    if(!empty($cgtData)){

        foreach($cgtData as $cgtK => $cgtV){
            if($cgtV['DeviceType'] != 'camera') continue;
            if(in_array($cgtV['DeviceUniqId'],$getDeviceIdList)){

                $avgData[$cgtV['DeviceUniqId']][$cgtV['hour']][] = $cgtV['value'];

                $ttm = new Datetime();
                if($t->format("Ymd") == $ttm->setTimestamp($cgtV['timestamp'])->format("Ymd") ){
                    $todayData[$cgtV['DeviceUniqId']][$cgtV['hour']][]= $cgtV;
                }

                if(empty($CheckTime[$cgtV['DeviceUniqId']]) || $CheckTime[$cgtV['DeviceUniqId']] < $cgtV['timestamp']){
                    //                 var_dump($CheckTime);
                    $tmpData[$cgtV['DeviceUniqId']]= $cgtV;
                    $CheckTime[$cgtV['DeviceUniqId']] = $cgtV['timestamp'];
                }

            }
        }
    }

    $timeArr = [0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23];
    //平均混雑率計算
    if(!empty($avgData)){
        foreach($avgData as $dvID => $dvData){
            $arr = [];
            foreach($timeArr as $tmK => $tmV){
                $arr[$tmV] = (isset($dvData[$tmV]))?array_sum($dvData[$tmV])/count($dvData[$tmV]):0;
            }
            $avgData[$dvID] = $arr;
        }
    }


    $tData = [];
    if(!empty($todayData)){
        foreach($todayData as $tdvID => $tdvData){

            foreach($timeArr as $tmK => $hour){
                $val = 0;
                if($hour > $t->format("G")*1) continue;
                if(isset($tdvData[$hour])){
                    $maxkey = getHashMaxKey($tdvData[$hour], 'timestamp');
                    $val = $tdvData[$hour][$maxkey]['value'];
                }

                $tData[$tdvID][$hour] = $val;
            }

        }
    }
    $congestionData = $tmpData;

    $dom = "";
    $pre_markerdom = "";
    $markerdom = "";
//     if($congestionData){
//         foreach($congestionData as $cgK => $cgV){
//             //         $pre_markerdom .= '<div class="pre_marker" data-setmarknum="'.$cgK.'" style="top: '.$top.'px; left: '.$left.'px;">';
//             //         $pre_markerdom .= '</div>';
//             $avgDataJson = json_encode($avgData[$cgV['DeviceUniqId']]);
//             $todayDataJson = json_encode($tData[$cgV['DeviceUniqId']]);

//             $top = $deviceDataList[$cgK]['y_pos']*5+30;
//             $left = $deviceDataList[$cgK]['x_pos']*5.2;
// //             $top = $cgV['y']*5;
// //             $left = $cgV['x']*5.2;

//             $ZahyouDom .= '<div class="marker_zahyou" style="top: '.$top.'px; left: '.$left.'px;" data-marker_num="'.$cgV['DeviceUniqId'].'" ></div>';

//             $markerdom .= '<div class="marker_p svg-wrap" data-marknum="'.$cgK.'" data-posx="'.$left.'" data-posy="'.$top.'" data-mapname = "'.$cgV['Name'].'" data-congest="'.$cgV['value'].'" data-congavg=\''.$avgDataJson.'\' data-todaycong = \''.$todayDataJson.'\' style="" data-toggle="modal" data-target="#modal-congestionconferenceinfo">';
//             $markerdom .= '<div class="marker-txt-wrap d-flex justify-content-center"><div class="t_congestion">'.$cgV['value'].'</div><div class="t_parcentage">%</div></div>';
//             $markerdom .= '<svg class="">';
//             $markerdom .= '<use xlink:href="./widget/'.$widget_name.'/img/marker_icon.svg#MarkerIcon"></use>';
//             $markerdom .= '</svg>';
//             $markerdom .= '</div>';
//         }
//     }
    if($deviceDataList){
        foreach($deviceDataList as $ddlK => $ddlV){
            //         $pre_markerdom .= '<div class="pre_marker" data-setmarknum="'.$cgK.'" style="top: '.$top.'px; left: '.$left.'px;">';
            //         $pre_markerdom .= '</div>';
            $avgDataJson = json_encode($avgData[$ddlV['du_id']]);
            $todayDataJson = json_encode($tData[$ddlV['du_id']]);
            //             $tmpkey = getHashKeyForeach($tmpData, 'du_id', $ddlV['du_id']);
            //             $tmpdd = $tmpData[$ddlV['du_id']];
            //             $congestValue = (!is_null($tmpdd['value']))?$tmpdd['value']:0;

            $congestValue = (end($tData[$ddlV['du_id']]))?end($tData[$ddlV['du_id']]):0;


            $top = $ddlV['y_pos']*3;
            $left = $ddlV['x_pos']*3.5;



            $ZahyouDom .= '<div class="marker_zahyou" style="top: '.$top.'px; left: '.$left.'px;" data-marker_num="'.$ddlV['du_id'].'" ></div>';

            $markerdom .= '<div class="marker_p svg-wrap" data-marknum="'.$ddlK.'" data-posx="'.$left.'" data-posy="'.$top.'" data-mapname = "'.$ddlV['name'].'" data-congest="'.$congestValue.'" data-congavg=\''.$avgDataJson.'\' data-todaycong = \''.$todayDataJson.'\' data-toggle="modal" data-target="#modal-congestionconferenceinfo">';
            $markerdom .= '<div class="marker-txt-wrap d-flex justify-content-center"><div class="t_congestion">'.$congestValue.'</div><div class="t_parcentage">%</div></div>';
            $markerdom .= '<svg class="">';
            $markerdom .= '<use xlink:href="./widget/'.$widget_name.'/img/marker_icon.svg#MarkerIcon"></use>';
            $markerdom .= '</svg>';
            $markerdom .= '</div>';
        }
    }

    $dom .= '<div class="areawrap">';
    $dom .= '<div class="rotatemap-wrap">';

    $dom .= '<div class="rotatemap-standby">';

    $dom .= '<div class="widget-imgmap-wrap">';

    $dom .= '<img class="widget-imgmap img-fluid" src="./asset/img/map/map9F.png" alt="" />';
    $dom .= '</div>';


    $dom .= '<div class="map_point_wrap">';
    $dom .= '<div class="map_point">';
    $dom .= $ZahyouDom;
    $dom .= '</div>';
    $dom .= '</div>';

    $dom .= '</div>';

    $dom .= '<div class=" graph">';
    $dom .= $markerdom;
    $dom .= '</div>';
    $dom .= '</div>';


    $dom .= '<div class="areainfo-wrap">';
    $dom .= '<div class="area-title">'.$f_name.'</div>';
    $dom .= '<div class="area-number">'.$f_num.'</div>';
    $dom .= '</div>';

    $dom .= '</div>';


    $ret = [
        'state' => 'success',
        'html' => $dom,
    ];

    $log->info('Successful common area congestion map conference load.',
        array('file' => __FILE__, 'user_id' => $user_id)
    );

    header('Content-Type: application/json; charset=utf-8', true);
    echo json_encode($ret);

}catch(Exception $e){

    $ret = [
        'state' => 'error',
        'msg' => $e->getMessage(),
    ];

    $log->info($e);
    $log->info('Failed to common area congestion map conference load.',
        array(
            'file' => __FILE__,
            'message' => $e->getMessage()
        )
    );

    header('Content-Type: application/json; charset=utf-8', true);
    echo json_encode($ret);
}

?>