var gradient = [
    [
        0,
        '00a99d',
        'いつもより空いています。',
    ],
    [
        20,
        '39b54a',
        '比較的空いています。',
    ],
    [
        40,
        'ff9900',
        'やや混雑しています。',
    ],
    [
        60,
        'ff3800',
        '多少混雑しています。',
    ],
    [
        80,
        'f20000',
        'かなり混雑しています。',
    ]
];


$(function(){

    $('#CongestionMapConferenceWidget .reload svg').on('click', function(){
        console.log('CongestionMapConferenceWidget reload');
    });


    // ページ読み込み時0.5秒後に描画
    setTimeout(function(){
        GetAjaxConferenceData();

    },500);



    $('#modal-congestionconferenceinfo').on('show.bs.modal', function(event) {
        var mapname = $(event.relatedTarget).data('mapname');

        $(this).find('#ModalWidgetConferenceCongestionText .congest-title').text(mapname);
        var congest = $(event.relatedTarget).data('congest');
//      $(this).find('.modal-body #ModalWidgetCongestionConferenceTitle').val(congest);

        $.each(gradient, function( index, value ) {
            if(congest == 0){
                color = value[1];
                text = value[2];
            }
            if(congest <= value[0]) {
                return false;
            }else{
                color = value[1];
                text = value[2];
            }
        });

        $(this).find('.modal-content').css({
            background: '#'+color,
        });
        $(this).find('.congest_text').text(text);


        $(this).find('.modal-congestgraph').circleProgress({
            size:40,
            max: 100,
            value: congest,
            animation: 'easeInOutCubic',
//          textFormat: 'percent',
            textFormat: function(value, max) {
                return '<tspan y="40%" x="50%">'+value + '</tspan><tspan class="parse" y="75%" x="50%">%</tspan>';
            },
        });

    });


    $('#modal-congestionconferenceinfo').on('shown.bs.modal', function(event) {
        var congavg = $(event.relatedTarget).data('congavg');
        var todaycong = $(event.relatedTarget).data('todaycong');
        DrawDailyGraphConference('ConfDailyGraph', congavg, todaycong);
    });

});


function GetAjaxConferenceData(){
    //JSONオブジェクト設定
    var fieldID = $('#CongestionConferenceMapWrap').data('fieldid');
//  var fieldname = $('#CongestionConferenceMapWrap').data('fieldname');
//  var fieldnum = $('#CongestionConferenceMapWrap').data('fieldnum');
//  var tenant = $('#CongestionConferenceMapWrap').data('tenant');

    var jsonData = {
            "f_id":fieldID,
            };

    $.ajax({
        type: "POST",
        url: "./widget/CongestionMapConferenceWidget/get_ajax.php",
        data: jsonData,
        dataType: "json",
        timeout: 10000
    }).done(function(response, textStatus, jqXHR) {
//          console.log(response);
//          return false;
        // 成功時処理

        if(response.state == 'success'){

            $('#CongestionMapConferenceWidget .widget-loading-area').html(response.html);
            $('#CongestionMapConferenceWidget .widget-loading-area').removeClass('d-none');
            $('#CongestionMapConferenceWidget .widget-body .loader_wrap').addClass('d-none');
            var $area = $('#CongestionMapConferenceWidget .areawrap');
            $area.css({'opacity':0});
//          console.log(response.html);

            $area.find('.marker_p').each(function(){

                var val = $(this).data('congest');

                var color = "";
                $.each(gradient, function( index, value ) {
                    if(val < value[0]) {
                        return false;
                    }else{
                        color = value[1];
                    }
                });

                $(this).find('svg').css({
                    color: '#'+color,
                });
                $(this).find('text.t_congestion').html(val);

            });

            $grid.imagesLoaded(function(){
                $grid.masonry('layout');
            });


//          var markerlist = $('#CongestionConferenceMapWrap').find('.marker_zahyou');
//          markerlist.each(function(i,v){
//              var y1 = $(v).position().top-30;
//              var x1 = $(v).position().left-90;
////                console.log($(v), $(v).position());
//              var num = $(v).data('marker_num');
//              var targ = $('.marker_p[data-marknum="'+num+'"]');
//              var t_w = targ.width()/2;
//              var t_h = targ.height();
//
//              targ.css({top:(y1-t_h)+'px', left:(x1-t_w)+'px'});
//          });

            setTimeout(() =>{

                var mstby = $area.find('.rotatemap-standby');
                var mimg = $area.find('.widget-imgmap');
                var mp = $area.find('.map_point');
                var mi_w = mimg.width();
                var mi_h = mimg.height();
                mp.css({height:mi_h+'px', width:mi_w+'px'});

                mstby.addClass('rotateMap');
                //                      mimg.addClass('rotateMap');
                //                      mp.addClass('rotateMap');

                $area.find('.marker_zahyou').each(function(i,v){
                    var y1 = $(v).position().top-35;
                    var x1 = $(v).position().left-60;


//                  console.log(y1,x1);
                    var num = $(v).data('marker_num');
                    var $targ = $area.find('.marker_p[data-marknum="'+num+'"]');
                    var t_w = $targ.width()/2;
                    var t_h = $targ.height();

                    $targ.css({top:(y1-t_h)+'px', left:(x1-t_w)+'px'});
                });
                $area.css({'opacity':1});
            },100);

        }else{
            $('#CongestionMapConferenceWidget .widget-loading-area').html('<div class="ajax_failed">ウィジェットの読み込みに失敗しました。</div>');

            $grid.imagesLoaded(function(){
                $grid.masonry('layout');
            });
        }





    }).fail(function(XMLHttpRequest,jqXHR, textStatus, errorThrown ) {
        // 失敗時処理
        console.log(XMLHttpRequest);
        $('#CongestionMapConferenceWidget .widget-loading-area').removeClass('d-none');
        $('#CongestionMapConferenceWidget .widget-body .loader_wrap').addClass('d-none');
        $('#CongestionMapConferenceWidget .widget-loading-area').html('<div class="ajax_failed">ウィジェットの読み込みに失敗しました。</div>');

        //alert('error!');
        return false;
    });
}



function DrawDailyGraphConference(id, avg, today){
    var time = [0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23];
    var chartDom = document.getElementById(id);
    var myChart = echarts.init(chartDom);
    const currentHour = today.length-1;
    const currentData = today.slice(-1)[0];

    var option;
    option = {

            grid: {
                  left: '10px',
                  top: '40px',
                  right: '10px',
                  bottom: '20px'
                },
            backgroundColor: 'rgba(255,255,255,0)',
            xAxis: [
                {
                    type: 'category',
//                  name: '時間',
//                  nameTextStyle: {
//                      color: '#fff'
//                  },
                    data: time,
                    position: 'bottom',
                    axisLine: {
                        lineStyle: {
                            color: '#fff',
                            fontWeight: 'bold',
                        },
                    },
                    axisTick: {
                        show: false
                    },
                    splitLine: {
                        lineStyle: {
                            // Dark and light colors will be used in turns
//                          color: ['#aaa', '#dd0']
                        }
                    }
                }
            ],
            yAxis: [
                {
                    type: 'value',
//                  name: '混雑度',
                    nameTextStyle: {
                        color: '#fff',
                    },
                    min: 0,
                    max: 100,
                    axisLabel: {
                        formatter: '{value}',
                        show: false,
                    },
//                  axisLine: {
//                      show: false,
//                  },
                    axisTick: {
                        show: false,
                        alignWithLabel: false,
                    },
                    splitLine: {
                        show: true,
                        lineStyle: {
                            color: 'rgba(255, 255, 255, 0.3)',
                        },
                    },
                    color: '#fff',
                    position: 'left',
                }
            ],
            series: [
                {
                    name: '平均混雑度',
                    type: 'bar',
                    data: avg,
                    color: 'rgba(255,255,255,0.3)',
                },
                {
                    name: '本日の混雑度',
                    type: 'line',
                    yAxisIndex: 0,
                    data: today,
                    color: '#fff',
                    markPoint: {
                        data: [
                            {
                                xAxis: currentHour,
                                yAxis: currentData,
//                              value: currentData,
                                label: {
                                    fontSize: '1.1em',
                                    formatter: currentData+'%',
                                },
                            }
                        ],
                    },
                }
            ]
        };

        option && myChart.setOption(option);
        myChart.resize;
}