<?php

require("../../core/construct.php");
require_once(__DIR__ . "/../../util/utils.php");

try{

    require(CORE_PATH."functions.php");
    require(CORE_PATH."session_check.php");

    require(SIGNAGE_ROOT."model/model.php");
    $sgMDL = new sngModel($sdb, $link);

    require(SUPER_APPLI_ROOT."model/model.php");
    $sapMDL = new sappModel($sdb, $link);

    require(ADMIN_ROOT."model/model.php");
    $admMDL = new admModel($sdb, $link);

    if(!isset($_SERVER['HTTP_X_REQUESTED_WITH']) || strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) !== 'xmlhttprequest') {
        throw new Exception('接続が安全ではありません。');
    }

    $POST = filterPost();

    $user_id = $_SESSION['login']['user_id'];
    $tenant = $_SESSION['login']['tenant_id'];
    $f_id = $POST['f_id'];
//     $user_id = $POST['user_id'];

    $f_row = $admMDL->GetFieldData($f_id);
    if(!$f_row) throw new Exception('エリアが登録されていません。');

    $u_row = $sapMDL->GetUserInfo($user_id);
    if(!$u_row) throw new Exception('ユーザー情報の読み込みが失敗しました。');

    $device_auth = explode(",", $u_row['device_authorize']);
//     pre($device_auth);exit;

    $f_name = $tenant;
    $f_num = $f_row['field_name'];


    //TODO 第三者APIから取得可能なデバイスのみ表示する
    $getDeviceIdList = [];
    $deviceDataList = [];
    $d_row = $sgMDL->GetDeviceTblByFieldIDControlable($f_id, $device_auth);
    if($d_row){
        foreach($d_row as $dK => $dV){
            //捜査権限のあるデバイスのみ表示する
            if(in_array($dV['du_id'], $device_auth)){
                if($dV['type'] === DEVICE_TYPE_CAMERA){
                    $deviceDataList[$dV['du_id']] = $dV;
                    $getDeviceIdList[] = $dV['du_id'];
                }
            }
        }
    }

    $t = new Datetime();
    $timestr = $t->format("Ym");
    $filename =  CONTENTS_PATH.'devicedata_'.$tenant.'_'.$timestr.'.txt';
    $fp = fopen($filename, 'a+');
    $cgtData = [];

    //一週間前までのログのみ取得
    $wt = new Datetime();
    $wt->modify("- 7 days");

    if ($fp){
        while ($fp && !feof($fp)) {
            $line = fgets($fp);
            if($line){

                $j_line = json_decode($line, True);
                if($wt->getTimestamp() > $j_line['timestamp']) continue;
                if($j_line['DeviceType'] != DEVICE_TYPE_CAMERA) continue;
                $cgtData[] = $j_line;
            }
        }
    }

//     $cgtData = array_map('json_decode', $cgtData, array_fill(0,count($cgtData), TRUE));

    $avgData = [];//平均混雑率


    $tmpData = [];
    $CheckTime = [];
    $todayData = [];
    if(!empty($cgtData)){

        //デバイスのログが存在する場合
        foreach($cgtData as $cgtK => $cgtV){
//             if($cgtV['DeviceType'] != 'camera') continue;
            if(in_array($cgtV['DeviceUniqId'],$getDeviceIdList)){

                $avgData[$cgtV['DeviceUniqId']][$cgtV['hour']][] = $cgtV['value'];

                $ttm = new Datetime();
                if($t->format("Ymd") == $ttm->setTimestamp($cgtV['timestamp'])->format("Ymd") ){
                    $todayData[$cgtV['DeviceUniqId']][$cgtV['hour']][]= $cgtV;
                }

                if(empty($CheckTime[$cgtV['DeviceUniqId']]) || $CheckTime[$cgtV['DeviceUniqId']] < $cgtV['timestamp']){
                    //                 var_dump($CheckTime);
                    $tmpData[$cgtV['DeviceUniqId']]= $cgtV;
                    $CheckTime[$cgtV['DeviceUniqId']] = $cgtV['timestamp'];
                }

            }
        }
    }else{
        //デバイスのログが存在しなかった場合
        foreach($deviceDataList as $ddK => $ddV){
//             if($ddV['type'] != 'camera') continue;
            $arr = $ddV;
            $arr['value'] = 0;
            $tmpData[]= $arr;
        }
    }

    $timeArr = [0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23];
    //平均混雑率計算
    if(!empty($avgData)){
        foreach($avgData as $dvID => $dvData){
            $arr = [];
            foreach($timeArr as $tmK => $tmV){
                $arr[$tmV] = (isset($dvData[$tmV]))?array_sum($dvData[$tmV])/count($dvData[$tmV]):0;
            }
            $avgData[$dvID] = $arr;
        }
    }

    //現在時刻（時）で最も最新の数値の取得
    $tData = [];
    if(!empty($todayData)){
        foreach($todayData as $tdvID => $tdvData){

            foreach($timeArr as $tmK => $hour){
                $val = 0;
                if($hour > $t->format("G")*1) continue;
                if(isset($tdvData[$hour])){
                    $maxkey = getHashMaxKey($tdvData[$hour], 'timestamp');
                    $val = $tdvData[$hour][$maxkey]['value'];
                }

                $tData[$tdvID][$hour] = $val;
            }

        }
    }

    $congestionData = $tmpData;

    $dom ="";
    $pre_markerdom = "";
    $markerdom = "";
    if($deviceDataList){
        foreach($deviceDataList as $ddlK => $ddlV){
            //         $pre_markerdom .= '<div class="pre_marker" data-setmarknum="'.$cgK.'" style="top: '.$top.'px; left: '.$left.'px;">';
            //         $pre_markerdom .= '</div>';
            $avgDataJson = json_encode($avgData[$ddlV['du_id']]);
            $todayDataJson = json_encode($tData[$ddlV['du_id']]);
            
//             $tmpkey = getHashKeyForeach($tmpData, 'du_id', $ddlV['du_id']);
//             $tmpdd = $tmpData[$ddlV['du_id']];
//             $congestValue = (!is_null($tmpdd['value']))?$tmpdd['value']:0;

            $congestValue = (end($tData[$ddlV['du_id']]))?end($tData[$ddlV['du_id']]):0;

            
            $top = $ddlV['y_pos']*3-30;
            $left = $ddlV['x_pos']*3.5;

            $ZahyouDom .= '<div class="marker_zahyou" style="top: '.$top.'px; left: '.$left.'px;" data-marker_num="'.$ddlV['du_id'].'" ></div>';

            $markerdom .= '<div class="marker_p svg-wrap" data-marknum="'.$ddlK.'" data-posx="'.$left.'" data-posy="'.$top.'" data-mapname = "'.$ddlV['name'].'" data-congest="'.$congestValue.'" data-congavg=\''.$avgDataJson.'\' data-todaycong = \''.$todayDataJson.'\' data-toggle="modal" data-target="#modal-tracongestioninfo">';
            $markerdom .= '<div class="marker-txt-wrap d-flex justify-content-center"><div class="t_congestion">'.$congestValue.'</div><div class="t_parcentage">%</div></div>';
            $markerdom .= '<svg class="">';
            $markerdom .= '<use xlink:href="./widget/CongestionTrafficMapWidget/img/marker_icon.svg#MarkerIcon"></use>';
            $markerdom .= '</svg>';
            $markerdom .= '</div>';
        }

    }

    $dom .= '<div class="areawrap">';
        $dom .= '<div class="rotatemap-wrap">';
        
            $dom .= '<div class="rotatemap-standby">';
        
                $dom .= '<div class="widget-imgmap-wrap">';
                   $dom .= '<img class="widget-imgmap img-fluid" src="./asset/img/map/1F.png" alt="" />';
                $dom .= '</div>';
            
            
                $dom .= '<div class="map_point_wrap">';
                    $dom .= '<div class="map_point">';
                        $dom .= $ZahyouDom;
                    $dom .= '</div>';
                $dom .= '</div>';
            $dom .= '</div>';
    
            $dom .= '<div class=" graph">';
                $dom .= $markerdom;
            $dom .= '</div>';
    
        $dom .= '</div>';

    // $dom .= '<div class="rotateMapBlank">';

    // $dom .= $pre_markerdom;

    // $dom .= '</div>';
        $dom .= '<div class="areainfo-wrap">';
            $dom .= '<div class="area-title">'.$f_name.'</div>';
            $dom .= '<div class="area-number">'.$f_num.'</div>';
        $dom .= '</div>';


    $dom .= '</div>';


    $ret = [
        'state' => 'success',
        'html' => $dom,
    ];

    // バス・タクシー待ち状況マップ読み込み成功
    $log->info('Successful bus taxi waiting condition map data load.',
        array('file' => __FILE__, 'user_id' => $user_id )
    );

    header('Content-Type: application/json; charset=utf-8', true);
    echo json_encode($ret);


}catch(Exception $e){

    $ret = [
        'state' => 'error',
        'msg' => $e->getMessage(),
    ];
    $mes = GetMsgEncode($e->getMessage());

     // バス・タクシー待ち状況マップ読み込み失敗
    $log->info($e);
    $log->info('Failed to bus taxi waiting codition map data load.',
        array(
            'file' => __FILE__,
            'user_id ' => $user_id,
            'message' => $e->getMessage()
        )
    );
    header('Content-Type: application/json; charset=utf-8', true);
    echo json_encode($ret);
}
?>