<?php
require_once("../../core/construct.php");
require_once(CORE_PATH."functions.php");
require_once(CORE_PATH."session_check.php");
require_once(SIGNAGE_ROOT."api.php");
require_once(__DIR__ . '/../../util/utils.php');

try{
    if(!isset($_SERVER['HTTP_X_REQUESTED_WITH']) || strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) !== 'xmlhttprequest') {
        throw new Exception('HTTP通信に失敗しました。');
    }
    // テキストファイルからデバイスタイプ取得
    $file_name =  __DIR__.'/../../../contents/devicetype_'.$_ENV["SITE_NAME"].'.txt';
    $file_handle = fopen($file_name, 'r');
    $file_content = fread($file_handle, filesize($file_name));
    $text_split = preg_split ('/^\d*_/',$file_content);
    fclose($file_handle);
    $json_data = json_decode($text_split[0], true);
    if(!$json_data){
        throw new Exception("デバイスタイプの取得に失敗しました");
    }
    $DevicetypeListDom = "";
    $Dom = "";
    $POST = filterPost();
    // 警報件数
    $alarm = $POST['alarm'];
    // ウィンドウサイズ
    $window_size = $POST['width'];
    // 全デバイス警報件数
    if($alarm != 0){
        $Dom .= '<div class="span_keihou" id="all_keihou" style="float: right">';
        if($window_size < 500){
            $Dom .= '<p class="text_keihou" style="width:97px;position:relative;left:7px;">全デバイス警報　</p>';
            $Dom .= '<p class="text_keihou" style="width:85px;position:relative;left:5px;"><span class="text_suti">'.number_format($alarm).'</span>件発生中</p>';
        }elseif($window_size > 499){
            $Dom .= '<p class="text_keihou" style="text-align:center;">全デバイス警報　<span class="text_suti">'.number_format($alarm).'</span>件発生中</p>';
        }
        $Dom .= '</div>';
    };
    // 機器選択プルダウンメニュー
    $Dom .= '<div class="selecttable">';
    $Dom .= '<select name="headername" id="HeaderDeviceName" class="device_selectbox">';
    $Dom .= '<option value="" selected>機器選択</option>';
    $json_count = count($json_data['res_device_type']);
    for($json_counter = 0; $json_counter < $json_count; $json_counter++){
        $Dom .= '<option value="'.$json_data['res_device_type'][$json_counter].'">'.$json_data['res_device_type'][$json_counter].'</option>';
    };
    $Dom .= '</select>';
    $Dom .= '<span class="device_selectbox_highlight"></span>';
    $Dom .= '<span class="device_selectbox_selectbar"></span>';
    $Dom .= '<label class="device_selectbox_selectlabel">機器を選択してください</label>';
    $Dom .= '</div>';
    $Dom .= '<div id="loading"><div class="loader005 d-none"></div></div>';
    $DevicetypeListDom .= '<div id="TableWrite">';
    // デバイスタイプ名
    $device_name = $POST['device'];
    if($device_name){
        // テキストファイルからデバイスタイプ情報取得
        $file_name =  __DIR__.'/../../../contents/devicedata_'.$device_name.'_'.$_ENV["SITE_NAME"].'.txt';
        $file_handle = fopen($file_name, 'r');
        $file_content = fread($file_handle, filesize($file_name));
        $text_split = preg_split ('/^\d*_/',$file_content);
        fclose($file_handle);
        $text_data = json_decode($text_split[0], true);
        $db_device_data_list = $text_data["db_device_data_list"];
        if(!$db_device_data_list){
            throw new Exception("DBデータの取得に失敗しました。");
        }
        $DevicetypeListDom .= '<div class="sticky_table_wrapper">';
        $DevicetypeListDom .= '<table id="DeviceListTables">';
        $DevicetypeListDom .= '<thead>';
        $DevicetypeListDom .= '<tr>';
        foreach($db_device_data_list as $db_device_data_list_key => $db_device_data_list_value){
            if($db_device_data_list_value['description'] == 'デバイス名'){
                $DevicetypeListDom .= '<th class=overflow-tooltip style="position: sticky;top: 0;left: 0;font-size: 12px;z-index:10;">'.$db_device_data_list_value['description'].'</th>';
            }else{
                $DevicetypeListDom .= '<th class=overflow-tooltip>'.$db_device_data_list_value['description'].'</th>';
            };
        };
        $empty_column = 0;
        $alarm_count = 0;
        // ウィンドウサイズに合わせて空のカラム作成
        if($window_size < 400){
            if(count($db_device_data_list) < 2){
                $empty_column = 2 - count($db_device_data_list);
                for($column_counter = $db_device_data_key; $column_counter < $empty_column; $column_counter++){
                    $DevicetypeListDom .= '<th class=overflow-tooltip>---</th>';
                };
            };
        }elseif($window_size > 401 && $window_size < 500){
            if(count($db_device_data_list) < 3){
                $empty_column = 3 - count($db_device_data_list);
                for($column_counter = $db_device_data_key; $column_counter < $empty_column; $column_counter++){
                    $DevicetypeListDom .= '<th class=overflow-tooltip>---</th>';
                };
            };
        }elseif($window_size > 501 && $window_size < 590){
            if(count($db_device_data_list) < 2){
                $empty_column = 2 - count($db_device_data_list);
                for($column_counter = $db_device_data_key; $column_counter < $empty_column; $column_counter++){
                    $DevicetypeListDom .= '<th class=overflow-tooltip>---</th>';
                };
            };
        }elseif($window_size > 589 && $window_size < 870){
            if(count($db_device_data_list) < 3){
                $empty_column = 3 - count($db_device_data_list);
                for($column_counter = $db_device_data_key; $column_counter < $empty_column; $column_counter++){
                    $DevicetypeListDom .= '<th class=overflow-tooltip>---</th>';
                };
            };
        }elseif($window_size > 869 && $window_size < 1130){
            if(count($db_device_data_list) < 4){
                $empty_column = 4 - count($db_device_data_list);
                for($column_counter = $db_device_data_key; $column_counter < $empty_column; $column_counter++){
                    $DevicetypeListDom .= '<th class=overflow-tooltip>---</th>';
                };
            };
        }elseif($window_size > 1129){
            if(count($db_device_data_list) < 5){
                $empty_column = 5 - count($db_device_data_list);
                for($column_counter = $db_device_data_key; $column_counter < $empty_column; $column_counter++){
                    $DevicetypeListDom .= '<th class=overflow-tooltip>---</th>';
                };
            };
        };
        $DevicetypeListDom .= '</tr>';
        $DevicetypeListDom .= '</thead>';
        $DevicetypeListDom .= '<tbody>';
        $res_device_data = $text_data["res_device_data"];
        if(!$res_device_data){
            throw new Exception("デバイス情報の取得に失敗しました。");
        }
        $json_count = count($res_device_data);
        $all_device = array();
        $all_table = array();
        // DX-Coreで取得したデータの数ループ
        for($json_counter = 0; $json_counter < $json_count; $json_counter++){
            $one_device = array();
            // １つの機器のファンクションの数ループ
            foreach($res_device_data[$json_counter] as $one_device_key => $one_device_value){
                // DBにある特定のデバイスのファンクションの数ループ
                foreach($db_device_data_list as $db_device_data_key => $db_device_data_value){
                    // 同じ名前のファンクションがあったら配列に入れる
                    if($db_device_data_value["device_function"] == $one_device_key){
                        $one_device[$db_device_data_value["device_function"]] = $one_device_value;
                    };
                };
                // 全ての機器の配列に１つ機器分入れる
                $all_device[$json_counter] = $one_device;
                $one_table = array();
                foreach($all_device as $one_table_key){
                    foreach($db_device_data_list as $db_device_data_key => $db_device_data_value){
                        // 同じ名前のファンクションがあったら配列に入れる
                        if(isset($one_table_key[$db_device_data_value["device_function"]]) === true){
                            $one_table[$db_device_data_value["device_function"]] = $one_table_key[$db_device_data_value["device_function"]];
                        // 同じ名前のファンクションがなかったらハイフン
                        }else{
                            $one_table[$db_device_data_value["device_function"]] = '---';
                        };
                    };
                };
                // 全ての機器の配列に１つ機器分入れる
                $all_table[$json_counter] = $one_table;
            };
        };
        // 機器ごとにループ
        foreach($all_table as $all_table_key => $all_table_value){
            // １つの機器のファンクション取得
            $device_json = (array)$res_device_data[$all_table_key];
            // １つの機器のファンクション数
            $device_count = count($device_json);
            $device_key = array_keys($device_json);
            $device_value = array_values($device_json);
            // モーダルの値初期化
            $data_model = null;
            // １つの機器のファンクションの数ループ
            for($device_counter = 0; $device_counter < $device_count; $device_counter++){
                // モーダル
                $data_model .= 'data-'.$device_key[$device_counter].'="'.$device_value[$device_counter].'"';
            };
            for($device_counter = 0; $device_counter < $device_count; $device_counter++){
                foreach($db_device_data_list as $db_device_data_key => $db_device_data_value){
                    if(($db_device_data_value["alarm_type"] ===  '0' || $db_device_data_value["alarm_type"] ===  '1' || $db_device_data_value["alarm_type"] ===  '2') && ($device_value[$device_counter] === 1) && ($device_key[$device_counter] === $db_device_data_value["device_function"])){
                        $data_model .= 'class = keihou';
                        $alarm_count = $alarm_count+1;
                    };
                };
            };
            $DevicetypeListDom .= '<tr '.$data_model.' data-toggle="modal" data-target="#modal-devicecontrol_dl">';
            // DBにある特定のデバイスのファンクションの数ループ(13)
            foreach($db_device_data_list as $db_device_data_key => $db_device_data_value){
                //例) JSON_OBJECT("0","OFF","1","ON")
                if($db_device_data_value['device_values']){
                    $db_json = json_decode($db_device_data_value['device_values'], true);
                    // json個数カウント
                    $count_db_json = count($db_json);
                    // 例）0、max
                    $db_key = array_keys($db_json);
                    // 例）OFF、80
                    $db_value = array_values($db_json);
                    // json個数分回す
                    for($db_counter = 0; $db_counter < $count_db_json; $db_counter++){
                        // 例) JSON_OBJECT("0","OFF","1","ON")
                        if(is_int($db_key[$db_counter]) == true){
                            // 例）0
                            if($all_table_value[$db_device_data_value["device_function"]] === $db_key[$db_counter]){
                                // 例）OFF
                                $DevicetypeListDom .= '<td>'.$db_value[$db_counter].'</td>';
                            };
                            if($all_table_value[$db_device_data_value["device_function"]] === '---'){
                                if($db_counter != 0){
                                    continue;
                                };
                                $DevicetypeListDom .= '<td>'.$all_table_value[$db_device_data_value["device_function"]].'</td>';
                            };
                        // 例) JSON_OBJECT("max",80,"min",10)
                        }elseif(is_int($db_key[$db_counter]) == false){
                            if($db_counter != 0){
                                continue;
                            };
                            if($all_table_value[$db_device_data_value["device_function"]] === '---'){
                                $DevicetypeListDom .= '<td>'.$all_table_value[$db_device_data_value["device_function"]].'</td>';
                            }else{
                                if($db_device_data_value["step_value"] === '0.5'){
                                    $number = sprintf('%.1f',$all_table_value[$db_device_data_value["device_function"]]);
                                    $DevicetypeListDom .= '<td>'.$number.''.$db_device_data_value["unit"].'</td>';
                                }else{
                                    $DevicetypeListDom .= '<td>'.$all_table_value[$db_device_data_value["device_function"]].''.$db_device_data_value["unit"].'</td>';
                                }
                            };
                        };
                    };
                }else{
                    if($all_table_value[$db_device_data_value["device_function"]] === '---'){
                        $DevicetypeListDom .= '<td>'.$all_table_value[$db_device_data_value["device_function"]].'</td>';
                    }else{
                        if(strpos($db_device_data_value["device_function"], 'Device.Info.') !== false){
                            $DevicetypeListDom .= '<td>'.$all_table_value[$db_device_data_value["device_function"]].'</td>';
                        }else{
                            if($db_device_data_value["step_value"] === '0.5'){
                                $number = sprintf('%.1f',$all_table_value[$db_device_data_value["device_function"]]);
                                $DevicetypeListDom .= '<td>'.$number.''.$db_device_data_value["unit"].'</td>';
                            }else{
                                $DevicetypeListDom .= '<td>'.$all_table_value[$db_device_data_value["device_function"]].''.$db_device_data_value["unit"].'</td>';
                            }
                        };
                    };
                };
            };
            if($empty_column){
                for($column_counter = 0; $column_counter < $empty_column; $column_counter++){
                    $DevicetypeListDom .= '<td>---</td>';
                };
            };
            $DevicetypeListDom .= '</tr>';
        };
        $DevicetypeListDom .= '</tbody>';
        $DevicetypeListDom .= '</table>';
        $DevicetypeListDom .= '</div>';
        // 選択デバイス警報件数/全デバイス警報件数
        if($alarm != 0){
            $DevicetypeListDom .= '<div class="device_keihou_kensu" style="float: right">';
            $DevicetypeListDom .= '<p class=keihou_all style="margin:auto;">';
            if($window_size < 500){
                if(intval($alarm_count) < 10){
                    $DevicetypeListDom .= '<p class="device_keihou_select" style="text-align:right;margin-top:3px;margin-bottom:-2px;margin-right:11px;font-size:11px;color:#FFF;white-space:nowrap;">選択デバイス警報　<span class="text_suti">'.number_format($alarm_count).'</span>件発生中</p>';
                }elseif(intval($alarm_count) < 100){
                    $DevicetypeListDom .= '<p class="device_keihou_select" style="position:relative;left:-3px;text-align:right;margin-top:3px;margin-bottom:-2px;margin-right:11px;font-size:11px;color:#FFF;white-space:nowrap;">選択デバイス警報　<span class="text_suti">'.number_format($alarm_count).'</span>件発生中</p>';
                }elseif(intval($alarm_count) > 99){
                    $DevicetypeListDom .= '<p class="device_keihou_select" style="position:relative;left:-11px;text-align:right;margin-top:3px;margin-bottom:-2px;margin-right:11px;font-size:11px;color:#FFF;white-space:nowrap;">選択デバイス警報　<span class="text_suti">'.number_format($alarm_count).'</span>件発生中</p>';
                }
                $DevicetypeListDom .= '<p class="device_keihou_all">全デバイス警報　<span class="text_suti">'.number_format($alarm).'</span>件発生中</p>';
            }elseif($window_size > 499){
                $DevicetypeListDom .= '<p class="device_keihou" style="text-align: center;">選択デバイス警報　<span class="text_suti">'.number_format($alarm_count).'</span>件発生中/全デバイス警報　<span class="text_suti">'.number_format($alarm).'</span>件発生中</p>';
            };
            $DevicetypeListDom .= '</p>';
            $DevicetypeListDom .= '</div>';
        };
    };
    $DevicetypeListDom .= '</div>';
    $dom = <<<EOM
        {$Dom}
        {$DevicetypeListDom}
    EOM;
    $ret = [
        'state' => 'success',
        'headerdevice' => $DevicetypeListDom,
        'html' => $dom,
        'db_device_data' => $db_device_data_list,
    ];
    $log->info('Successful widget loaded.', array('file' => __FILE__, 'user_id' => $_SESSION['login']['user_id']));
    header('Content-Type: application/json; charset=utf-8', true);
    echo json_encode($ret);
}catch(Exception $e){
    $ret = [
        'state' => 'error',
        'msg' => $e->getMessage()
    ];
    $log->error($e);
    $log->error('Failed widget loaded.', array('file' => __FILE__, 'user_id' => $_SESSION['login']['user_id'], 'message' => $e->getMessage()));
    header('Content-Type: application/json; charset=utf-8', true);
    echo json_encode($ret);
};
?>
