$(function () {
    // ページ読み込み時0.5秒後に描画
    setTimeout(function () {
        getAjaxDeviceStatusList();
    }, 500);
    setInterval(function () {
        var element = document.getElementById('HeaderDeviceName').value;
        if (!element == "") {
            var object = document.getElementsByName("DeviceListTables_length")[0];
            var selectIndex = object.selectedIndex;
            var selectText = object.options[selectIndex].text;
            if (isNaN(selectText) === true) {
                selectText = -1;
            };
            var lists = Array.from(document.querySelectorAll("li"));
            var index = lists.findIndex(list =>
                Array.from(list.classList).includes("active")
            )
            // デバイスタイプごとのページ保持
            reloadAjaxTable(element, selectText, index);
        } else if (element == "") {
            getAjaxDeviceStatusList();
        }
    }, 60000);
    // 機器が選択されたら描画
    $(document).on('change', '#HeaderDeviceName', function () {
        var deviceTypeName = $(this).val();
        if (deviceTypeName !== '') {
            $('#DeviceStatusListWrap .widget-loading-area .span_keihou').addClass('d-none');
        } else if (deviceTypeName === '') {
            $('#DeviceStatusListWrap .widget-loading-area .span_keihou').removeClass('d-none');
        };
        $('#loading .loader005').removeClass('d-none');
        $('#DeviceListTables_wrapper').addClass('d-none');
        ajaxTable(deviceTypeName);
    });
    //モーダル
    var template = null;

    $('#modal-devicecontrol_dl').on('show.bs.modal', function (event) {
        // モーダル初期化
        if (template == null) {
            template = $(this).html();
        } else {
            $(this).html(template);
        };
        var deviceId = $(event.relatedTarget).data('device.info.id');
        $(this).find('.devicetype-wrap').removeClass('d-none');
        $(this).find('#DeviceId').val(deviceId);
        // db数
        var dbLength = Object.keys(globalDBData).length;
        // int型に変換
        var dbCount = Number(dbLength);
        // 最初のid
        var dbKey = Object.keys(globalDBData);
        // int型に変換
        var dbKeyNumber = Number(dbKey[0]);
        // dbをループする回数を求める
        dbCount += dbKeyNumber;
        // db分ループ
        for (var dbCounter = dbKey[0]; dbCounter < dbCount; dbCounter++) {
            if (globalDBData[dbCounter] == null) {
                continue;
            };
            if (globalDBData[dbCounter]['value_type'] === 'checkbox' || globalDBData[dbCounter]['value_type'] === 'range' || globalDBData[dbCounter]['value_type'] === 'selectbox') {
                $(this).find('.modal-footer').removeClass('d-none');
            };
            // 大文字を小文字に変換
            var toLowerCase = globalDBData[dbCounter]['device_function'].toLowerCase();
            // Device.Status.をとる
            var specificString = globalDBData[dbCounter]['device_function'].slice(14,);
            if (globalDBData[dbCounter]['device_function'] == 'Device.Info.Description') {
                // デバイス名
                var deviceName = $(event.relatedTarget).data(toLowerCase);
                $(this).find('#ModalWidgetControlDLTitle').text(deviceName);
                $(this).find('.devicetype-wrap').removeClass('d-none');
            } else {
                if (globalDBData[dbCounter]['device_values']) {
                    globalJson = JSON.parse(globalDBData[dbCounter]['device_values']);
                    globalcount = Object.keys(globalJson).length;
                    globalJsonKey = Object.keys(globalJson);
                    globalJsonValue = Object.values(globalJson);
                };
                if (globalDBData[dbCounter]['device_function'] === 'Device.Status.RunningControl' && globalDBData[dbCounter]['value_type'] == 'checkbox') {
                    // ON/OFF制御
                    var onOffstatus = $(event.relatedTarget).data(toLowerCase);
                    if (onOffstatus === 0 || onOffstatus === 1) {
                        $(this).find(`.control-box .onoffseigyo`).removeClass('d-none');
                        $(this).find(`.control-box .device-state`).removeClass('d-none');
                        $(this).find(`.control-box .custom-switch`).removeClass('d-none');
                        var checkOnOff = (onOffstatus == '1') ? true : false;
                        $(this).find(`#FacilityListSetting`).prop('checked', checkOnOff);
                        var onOffStatus = (onOffstatus == '1') ? 'ON' : 'OFF';
                        $(this).find(`.control-box .device-state`).text(onOffStatus);
                        $(this).find(`.custom-control-input`).val(onOffStatus);
                        $(this).find(`.control-box .onoffseigyo`).text(`【${globalDBData[dbCounter]['description']}】`);
                        $(`#modal-devicecontrol_dl .custom-switch`).find("input[type=checkbox]").on('click', function () {
                            var onOffValue = $(this).val();
                            var controlBox = $(this).closest('.control-box');
                            if (onOffValue == 'ON') {
                                $(`.custom-control-input`).val('OFF');
                                controlBox.find(`.device-state`).text('OFF');
                            } else if (onOffValue == 'OFF') {
                                $(`.custom-control-input`).val('ON');
                                controlBox.find(`.device-state`).text('ON');
                            };
                        });
                    };
                } else if (globalDBData[dbCounter]['device_function'] === 'Device.Status.HeatingAndCoolingControl') {
                    // 暖房/冷房制御
                    var statusHeatingCooling = $(event.relatedTarget).data(toLowerCase);
                    if (statusHeatingCooling === 0 || statusHeatingCooling === 1) {
                        $(this).find(`.control-box .reidanbo`).removeClass('d-none');
                        $(this).find(`.control-box .reidan-state`).removeClass('d-none');
                        $(this).find(`.control-box .form-switch`).removeClass('d-none');
                        var checkHeatingCooling = (statusHeatingCooling == '0') ? true : false;
                        $(this).find(`#flexSwitchCheckDefault`).prop('checked', checkHeatingCooling);
                        var heatingCoolingStatus = (statusHeatingCooling == '0') ? '冷房' : '暖房';
                        $(this).find(`.control-box .reidan-state`).text(heatingCoolingStatus);
                        $(this).find(`.form-check-input`).val(heatingCoolingStatus);
                        $(this).find(`.control-box .reidanbo`).text(`【${globalDBData[dbCounter]['description']}】`);
                        $(`#modal-devicecontrol_dl .form-switch`).find("input[type=checkbox]").on('change', function () {
                            var heatingCoolingValue = $(this).val();
                            var controlBox = $(this).closest('.control-box');
                            if (heatingCoolingValue == '冷房') {
                                $(`.form-check-input`).val('暖房');
                                controlBox.find(`.reidan-state`).text('暖房');
                            } else if (heatingCoolingValue == '暖房') {
                                $(`.form-check-input`).val('冷房');
                                controlBox.find(`.reidan-state`).text('冷房');
                            };
                        });
                    };
                } else if (globalDBData[dbCounter]['device_function'] === 'Device.Status.Lighting') {
                    // 照明ONOFF
                    var statusLight = $(event.relatedTarget).data(toLowerCase);
                    if (statusLight === 0 || statusLight === 1) {
                        $(this).find(`.control-box .lightControl`).removeClass('d-none');
                        $(this).find(`.control-box .lightcl-state`).removeClass('d-none');
                        $(this).find(`.control-box .lightcl-switch`).removeClass('d-none');
                        var checkLight = (statusLight == '1') ? true : false;
                        $(this).find(`#flexSwitchCheckLight`).prop('checked', checkLight);
                        var lightStatus = (statusLight == '1') ? '点灯' : '消灯';
                        $(this).find(`.control-box .lightcl-state`).text(lightStatus);
                        $(this).find(`.form-lightcl-input`).val(lightStatus);
                        $(this).find(`.control-box .lightControl`).text(`【${globalDBData[dbCounter]['description']}】`);
                        $(`#modal-devicecontrol_dl .lightcl-switch`).find("input[type=checkbox]").on('change', function () {
                            var lightValue = $(this).val();
                            var controlBox = $(this).closest('.control-box');
                            if (lightValue == '点灯') {
                                $(`.form-lightcl-input`).val('消灯');
                                controlBox.find(`.lightcl-state`).text('消灯');
                            } else if (lightValue == '消灯') {
                                $(`.form-lightcl-input`).val('点灯');
                                controlBox.find(`.lightcl-state`).text('点灯');
                            };
                        });
                    };
                } else if (globalDBData[dbCounter]['value_type'] == 'measure') {
                    // 温度(給気温度・中温冷水送水温度・室内)、温度設定(中温冷水送水温度)、累積値、累積最大値、温度設定最大値・最小値給気(室内・給気)、中温冷水送水待機中・CO2濃度
                    var deviceFunction = $(event.relatedTarget).data(toLowerCase);
                    if (deviceFunction !== null && deviceFunction !== undefined) {
                        $(this).find(`.control-box .control_measure_${globalDBData[dbCounter]['device_type']}${specificString}`).removeClass('d-none');
                    };
                    if (globalDBData[dbCounter]['step_value'] === '0.5') {
                        var Int = Number(deviceFunction);
                        $(this).find(`.control-box .control_measure_${globalDBData[dbCounter]['device_type']}${specificString} p`).text(`${Int.toFixed(1)}${globalDBData[dbCounter]['unit']}`);
                    } else {
                        $(this).find(`.control-box .control_measure_${globalDBData[dbCounter]['device_type']}${specificString} p`).text(`${deviceFunction}${globalDBData[dbCounter]['unit']}`);
                    };
                    $(this).find(`.control-box .control_measure_${globalDBData[dbCounter]['device_type']}${specificString} label`).text(`【${globalDBData[dbCounter]['description']}】`);
                    if (specificString == "MinTemp") {
                        // 温度設定最小値
                        if (globalDBData[dbCounter]['step_value'] === '0.5') {
                            globalSize.min = Int.toFixed(1);
                        } else {
                            globalSize.min = deviceFunction;
                        };
                    } else if (specificString == "MaxTemp") {
                        // 温度設定最大値
                        if (globalDBData[dbCounter]['step_value'] === '0.5') {
                            globalSize.max = Int.toFixed(1);
                        } else {
                            globalSize.max = deviceFunction;
                        }
                    };
                } else if (globalDBData[dbCounter]['value_type'] == 'range') {
                    // 温度設定(給気温度・室内)・還気湿度設定・CO2濃度設定
                    var deviceRange = $(event.relatedTarget).data(toLowerCase);
                    if (deviceRange !== null && deviceRange !== undefined) {
                        $(this).find(`.control-box .control_range_${globalDBData[dbCounter]['device_type']}${specificString}`).removeClass('d-none');
                        if (globalDBData[dbCounter]['step_value'] === '0.5') {
                            var stepNumber = Number(deviceRange);
                            var stepInt = stepNumber.toFixed(1);
                            document.querySelector(`input[name='temp${specificString}']`).value = stepInt;
                        } else {
                            document.querySelector(`input[name='temp${specificString}']`).value = deviceRange;
                        }
                        $(this).find(`.control-box .control_range_${globalDBData[dbCounter]['device_type']}${specificString} p`).text(`【${globalDBData[dbCounter]['description']}】`);
                        globalSize = document.getElementById(`InputDeviceLevel${specificString}`);
                    };
                } else if (globalDBData[dbCounter]['value_type'] == 'selectbox') {
                    // 風量
                    var selectValue = $(event.relatedTarget).data(toLowerCase);
                    if (selectValue !== null && selectValue !== undefined) {
                        $(this).find(`.control-box .control_select_${globalDBData[dbCounter]['device_type']}${specificString}`).removeClass('d-none');
                    };
                    for (var selectValueCounter = 0; selectValueCounter < globalcount; selectValueCounter++) {
                        if (globalJsonKey[selectValueCounter] == selectValue) {
                            $(this).find(`.control-box .control_select_${globalDBData[dbCounter]['device_type']}${specificString} p`).text(`【${globalDBData[dbCounter]['description']}】`);
                            $(`#selecttarget${globalDBData[dbCounter]['device_type']}${specificString}`).find(`option[value='${globalJsonValue[selectValueCounter]}']`).attr("selected", "selected");
                        };
                    };
                } else if (globalDBData[dbCounter]['value_type'] == 'status') {
                    // 供給状態・火災制御状況・不足電圧状態・警報・中温冷水送水待機中・計測値/状態/警報・警報
                    var allStatus = $(event.relatedTarget).data(toLowerCase);
                    if (allStatus === 0 || allStatus === 1 || allStatus === 2 || allStatus === 3 || allStatus === 4) {
                        $(this).find(`.control-box .control_status_${globalDBData[dbCounter]['device_type']}${specificString}`).removeClass('d-none');
                        var allText = (allStatus == '1') ? globalJsonValue[1] : globalJsonValue[0];
                        $(this).find(`.control-box .control_status_${globalDBData[dbCounter]['device_type']}${specificString} p`).text(allText);
                        $(this).find(`.control-box .control_status_${globalDBData[dbCounter]['device_type']}${specificString} label`).text(`【${globalDBData[dbCounter]['description']}】`);
                    };
                };
            };

            $(`#modal-devicecontrol_dl .control_select_${globalDBData[dbCounter]['device_type']}${specificString}`).find("input[type=select]").on("change", function () {
                var selectValue = $(this).val();
                var controlBox = $(this).closest('.control-box');
                controlBox.find(`.selectbox${airset}`).text(selectValue);
            });
            if (globalDBData[dbCounter]['value_type'] == 'range') {
                if (specificString == 'SupplyAirTempSetting') {
                    var SupplyAirTempSetting = "SupplyAirTempSetting";
                    const wrap = document.querySelector(`.device${SupplyAirTempSetting}`)
                    const input = wrap.querySelector(`input[type=number]`)
                    wrap.querySelector(`.down-${SupplyAirTempSetting}`).onclick = () => {
                        input.stepDown()
                        var tempValue = document.querySelector(`input[name='temp${SupplyAirTempSetting}']`);
                        var tempNumber = Number(tempValue.value);
                        var tempInt = tempNumber.toFixed(1);
                        document.querySelector(`input[name='temp${SupplyAirTempSetting}']`).value = tempInt;
                    };
                    wrap.querySelector(`.up-${SupplyAirTempSetting}`).onclick = () => {
                        input.stepUp()
                        var tempValue = document.querySelector(`input[name='temp${SupplyAirTempSetting}']`);
                        var tempNumber = Number(tempValue.value);
                        var tempInt = tempNumber.toFixed(1);
                        document.querySelector(`input[name='temp${SupplyAirTempSetting}']`).value = tempInt;
                    };
                } else if (specificString == 'TempControl') {
                    var TempControl = "TempControl";
                    const wrap = document.querySelector(`.device${TempControl}`)
                    const input = wrap.querySelector(`input[name='temp${TempControl}']`)
                    wrap.querySelector(`.down-${TempControl}`).onclick = () => {
                        input.stepDown()
                        var tempValue = document.querySelector(`input[name='temp${TempControl}']`);
                        var tempNumber = Number(tempValue.value);
                        var tempInt = tempNumber.toFixed(1);
                        document.querySelector(`input[name='temp${TempControl}']`).value = tempInt;
                    };
                    wrap.querySelector(`.up-${TempControl}`).onclick = () => {
                        input.stepUp()
                        var tempValue = document.querySelector(`input[name='temp${TempControl}']`);
                        var tempNumber = Number(tempValue.value);
                        var tempInt = tempNumber.toFixed(1);
                        document.querySelector(`input[name='temp${TempControl}']`).value = tempInt;
                    };
                } else if (specificString == 'ReturnAirHumiditySetting') {
                    var ReturnAirHumiditySetting = "ReturnAirHumiditySetting";
                    const wrap = document.querySelector(`.device${ReturnAirHumiditySetting}`)
                    const input = wrap.querySelector(`input[name='temp${ReturnAirHumiditySetting}']`)
                    wrap.querySelector(`.down-${ReturnAirHumiditySetting}`).onclick = () => {
                        input.stepDown()
                    };
                    wrap.querySelector(`.up-${ReturnAirHumiditySetting}`).onclick = () => {
                        input.stepUp()
                    };
                } else if (specificString == 'TempSetting') {
                    var TempSetting = "TempSetting";
                    const wrap = document.querySelector(`.device${TempSetting}`)
                    const input = wrap.querySelector(`input[name='temp${TempSetting}']`)
                    wrap.querySelector(`.down-${TempSetting}`).onclick = () => {
                        input.stepDown()
                    };
                    wrap.querySelector(`.up-${TempSetting}`).onclick = () => {
                        input.stepUp()
                    };
                } else if (specificString == 'CO2Setting') {
                    var CO2Setting = "CO2Setting";
                    const wrap = document.querySelector(`.device${CO2Setting}`)
                    const input = wrap.querySelector(`input[name='temp${CO2Setting}']`)
                    wrap.querySelector(`.down-${CO2Setting}`).onclick = () => {
                        input.stepDown()
                    };
                    wrap.querySelector(`.up-${CO2Setting}`).onclick = () => {
                        input.stepUp()
                    };
                } else if (specificString == 'SupplyAirTempControl') {
                    var SupplyAirTempControl = "SupplyAirTempControl";
                    const wrap = document.querySelector(`.device${SupplyAirTempControl}`)
                    const input = wrap.querySelector(`input[name='temp${SupplyAirTempControl}']`)
                    wrap.querySelector(`.down-${SupplyAirTempControl}`).onclick = () => {
                        input.stepDown()
                        var tempValue = document.querySelector(`input[name='temp${SupplyAirTempControl}']`);
                        var tempNumber = Number(tempValue.value);
                        var tempInt = tempNumber.toFixed(1);
                        document.querySelector(`input[name='temp${SupplyAirTempControl}']`).value = tempInt;
                    };
                    wrap.querySelector(`.up-${SupplyAirTempControl}`).onclick = () => {
                        input.stepUp()
                        var tempValue = document.querySelector(`input[name='temp${SupplyAirTempControl}']`);
                        var tempNumber = Number(tempValue.value);
                        var tempInt = tempNumber.toFixed(1);
                        document.querySelector(`input[name='temp${SupplyAirTempControl}']`).value = tempInt;
                    };
                };
            };
        };

        $('#modalhenkou').unbind().click(function () {
            let deviceId = $('#modal-devicecontrol_dl').find('#DeviceId').val();
            let prm = {};
            prm.type = globalDeviceType.device;
            var dbLength = Object.keys(globalDBData).length;
            var dbCount = Number(dbLength);
            var dbKey = Object.keys(globalDBData);
            var dbKeyNumber = Number(dbKey[0]);
            dbCount += dbKeyNumber;
            for (var dbCounter = dbKey[0]; dbCounter < dbCount; dbCounter++) {
                if (globalDBData[dbCounter] == null) {
                    continue;
                };
                var specificString = globalDBData[dbCounter]['device_function'].slice(14,);
                if (globalDBData[dbCounter]['device_values']) {
                    globalJson = JSON.parse(globalDBData[dbCounter]['device_values']);
                    globalcount = Object.keys(globalJson).length;
                    globalJsonKey = Object.keys(globalJson);
                    globalJsonValue = Object.values(globalJson);
                };
                if (globalDBData[dbCounter]['device_function'] === 'Device.Status.SupplyAirTempSetting') {
                    var status = $('#modal-devicecontrol_dl').find(`.no-style-input${specificString}`).val();
                    if (status) {
                        prm.TempSetting = $('#modal-devicecontrol_dl').find(`.no-style-input${specificString}`).val();
                    };
                } else if (globalDBData[dbCounter]['device_function'] === 'Device.Status.TempSetting') {
                    var status = $('#modal-devicecontrol_dl').find(`.no-style-input${specificString}`).val();
                    if (status) {
                        prm.TmpStt = $('#modal-devicecontrol_dl').find(`.no-style-input${specificString}`).val();
                    };
                } else if (globalDBData[dbCounter]['device_function'] === 'Device.Status.ReturnAirHumiditySetting') {
                    var status = $('#modal-devicecontrol_dl').find(`.no-style-input${specificString}`).val();
                    if (status) {
                        prm.Humidity = $('#modal-devicecontrol_dl').find(`.no-style-input${specificString}`).val();
                    };
                } else if (globalDBData[dbCounter]['device_function'] === 'Device.Status.CO2Setting') {
                    var status = $('#modal-devicecontrol_dl').find(`.no-style-input${specificString}`).val();
                    if (status) {
                        prm.co2 = $('#modal-devicecontrol_dl').find(`.no-style-input${specificString}`).val();
                    };
                } else if (globalDBData[dbCounter]['device_function'] === 'Device.Status.SupplyAirTempControl') {
                    var status = $('#modal-devicecontrol_dl').find(`.no-style-input${specificString}`).val();
                    if (status) {
                        prm.SupplyAirTemp = $('#modal-devicecontrol_dl').find(`.no-style-input${specificString}`).val();
                    };
                } else if (globalDBData[dbCounter]['device_function'] === 'Device.Status.TempControl') {
                    var status = $('#modal-devicecontrol_dl').find(`.no-style-input${specificString}`).val();
                    if (status) {
                        prm.Temp = $('#modal-devicecontrol_dl').find(`.no-style-input${specificString}`).val();
                    };
                } else if (globalDBData[dbCounter]['device_function'] == 'Device.Status.ModeSetting') {
                    var obj = document.getElementById(`selecttarget${globalDBData[dbCounter]['device_type']}${specificString}`);
                    var idx = obj.selectedIndex;
                    var status = obj.options[idx].text;
                    for (var jsonValue = 0; jsonValue < globalcount; jsonValue++) {
                        if (status == globalJsonValue[jsonValue]) {
                            var key = globalJsonKey[jsonValue];
                        };
                    };
                    var keyInt = Number(key);
                    if (keyInt) {
                        prm.mode = keyInt;
                    };
                } else if (globalDBData[dbCounter]['device_function'] == 'Device.Status.AirVolumeControl') {
                    var obj = document.getElementById(`selecttarget${globalDBData[dbCounter]['device_type']}${specificString}`);
                    var idx = obj.selectedIndex;
                    var status = obj.options[idx].text;
                    for (var jsonValue = 0; jsonValue < globalcount; jsonValue++) {
                        if (status == globalJsonValue[jsonValue]) {
                            var key = globalJsonKey[jsonValue];
                        };
                    };
                    var keyInt = Number(key);
                    if (keyInt) {
                        prm.select = keyInt;
                    };
                } else if (globalDBData[dbCounter]['device_function'] === 'Device.Status.HeatingAndCoolingControl') {
                    var status = $(`.form-check-input`).val();
                    for (var jsonValue = 0; jsonValue < globalcount; jsonValue++) {
                        if (status == globalJsonValue[jsonValue]) {
                            var key = globalJsonKey[jsonValue];
                        };
                    };
                    var keyInt = Number(key);
                    if (keyInt === 0 || keyInt === 1) {
                        prm.reidan = keyInt;
                    };
                } else if (globalDBData[dbCounter]['device_function'] === 'Device.Status.RunningControl') {
                    var status = $(`.custom-control-input`).val();
                    for (var jsonValue = 0; jsonValue < globalcount; jsonValue++) {
                        if (status == globalJsonValue[jsonValue]) {
                            var key = globalJsonKey[jsonValue];
                        };
                    };
                    var keyInt = Number(key);
                    if (keyInt === 0 || keyInt === 1) {
                        prm.onoff = keyInt;
                    };
                } else if (globalDBData[dbCounter]['device_function'] === 'Device.Status.Lighting') {
                    var status = $(`.form-lightcl-input`).val();
                    for (var jsonValue = 0; jsonValue < globalcount; jsonValue++) {
                        if (status == globalJsonValue[jsonValue]) {
                            var key = globalJsonKey[jsonValue];
                        };
                    };
                    var keyInt = Number(key);
                    if (keyInt === 0 || keyInt === 1) {
                        prm.light = keyInt;
                    };
                };
            };
            SetAjaxFacilityControl(deviceId, prm, $('#modalhenkou'));
        });
    });
});

function ajaxTable(deviceTypeName) {
    $.ajax({
        type: "POST",
        url: "./widget/FacilityListWidget/keihou_ajax.php",
        timeout: 100000
    }).done(function (response, textStatus, jqXHR) {
        if (response.state == 'success') {
            globalDeviceType = new Object();
            globalDeviceType.device = deviceTypeName;
            globalDeviceType.alarm = response.alarm;
            globalDeviceType.width = $(window).width();
            if (globalDeviceType.device === "") {
                getAjaxDeviceStatusList();
            }
            $.ajax({
                type: 'POST',
                url: './widget/FacilityListWidget/get_ajax.php',
                data: globalDeviceType
            }).done(function (result) {
                if (result.state == 'success') {
                    // SQL
                    globalDBData = result.db_device_data;
                    setTimeout(function () {
                        $('#DeviceListTables_wrapper').removeClass('d-none');
                    }, 1000);
                    $('#loading .loader005').addClass('d-none');
                    $('#TableWrite').html(result.headerdevice);
                    $("#DeviceListTables").DataTable({
                        // 日本語化
                        language: {
                            url: 'widget/FacilityListWidget/DataTables-1.10.24/lang/ja.json'
                        },
                        // 検索機能 無効
                        searching: false,
                        // ソート機能 有効
                        ordering: true,
                        // 情報表示 無効
                        info: false,
                        // ページング機能 有効
                        paging: true,
                        // 初期表示件数
                        pageLength: 10,
                        // 件数表示 有効
                        lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, "全"]],//表示件数メニュー
                        // 横スクロール 有効
                        scrollX: true,
                        // 縦スクロール 有効
                        scrollY: 435,
                        // オプションレイアウト
                        "dom": '<"top"fli>rt<"bottom"p><"clear">'
                    });
                } else {
                    alert('設備リストの読み込みに失敗しました。');
                };
            }).fail(function () {
                // 失敗
                alert('設備リストの読み込みに失敗しました。');
            }).always(function (result) {
            });
        } else {
            alert('設備リストの読み込みに失敗しました。');
        };
    }).fail(function () {
        // 失敗
        alert('設備リストの読み込みに失敗しました。');
    }).always(function (result) {
    });
};

function reloadAjaxTable(deviceTypeName, displayNumber, page) {
    var pageNumber = Number(page) * Number(displayNumber) - Number(displayNumber);
    $.ajax({
        type: "POST",
        url: "./widget/FacilityListWidget/keihou_ajax.php",
        timeout: 100000
    }).done(function (response, textStatus, jqXHR) {
        if (response.state == 'success') {
            // 警報件数
            globalDeviceType = new Object();
            globalDeviceType.device = deviceTypeName;
            globalDeviceType.alarm = response.alarm;
            globalDeviceType.width = $(window).width();
            $.ajax({
                type: 'POST',
                url: './widget/FacilityListWidget/get_ajax.php',
                data: globalDeviceType
            }).done(function (result) {
                if (result.state == 'success') {
                    // SQL
                    globalDBData = result.db_device_data;
                    $('#TableWrite').html(result.headerdevice);
                    $("#DeviceListTables").DataTable({
                        // 日本語化
                        language: {
                            url: 'widget/FacilityListWidget/DataTables-1.10.24/lang/ja.json'
                        },
                        // 検索機能 無効
                        searching: false,
                        // ソート機能 有効
                        ordering: true,
                        // 情報表示 無効
                        info: false,
                        // ページング機能 有効
                        paging: true,
                        displayStart: pageNumber,
                        // 初期表示件数
                        pageLength: Number(displayNumber),
                        // 件数表示 有効
                        lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, "全"]],//表示件数メニュー
                        // 横スクロール 有効
                        scrollX: true,
                        // 縦スクロール 有効
                        scrollY: 435,
                        // オプションレイアウト
                        "dom": '<"top"fli>rt<"bottom"p><"clear">'
                    });
                } else {
                    alert('設備リストの読み込みに失敗しました。');
                };
            }).fail(function () {
                // 失敗
                alert('設備リストの読み込みに失敗しました。');
            }).always(function (result) {
            });
        } else {
            alert('設備リストの読み込みに失敗しました。');
        };
    }).fail(function () {
        // 失敗
        alert('設備リストの読み込みに失敗しました。');
    }).always(function (result) {
    });
};
function getAjaxDeviceStatusList() {
    $.ajax({
        type: "POST",
        url: "./widget/FacilityListWidget/keihou_ajax.php",
        timeout: 100000
    }).done(function (response, textStatus, jqXHR) {
        if (response.state == 'success') {
            // 警報件数
            AlarmNumber = new Object();
            AlarmNumber.alarm = response.alarm;
            AlarmNumber.width = $(window).width();
            $.ajax({
                type: "POST",
                url: "./widget/FacilityListWidget/get_ajax.php",
                data: AlarmNumber,
                timeout: 100000
            }).done(function (response, textStatus, jqXHR) {
                if (response.state == 'success') {
                    // 成功時処理
                    $('#FacilityListWidget .widget-loading-area').html(response.headerdevice);
                    $('#FacilityListWidget .widget-loading-area').html(response.html);
                    $('#FacilityListWidget .widget-loading-area').removeClass('d-none');
                    $('#FacilityListWidget .widget-body .loader_wrap').addClass('d-none');
                    $('#DeviceListTables').DataTable({
                        pageLength: 6,
                        searching: false,
                        info: false,
                        lengthChange: false,
                        dom: 'tp',
                        language: {
                            url: 'widget/FacilityListWidget/DataTables-1.10.24/lang/ja.json'
                        }
                    });
                    $('#DeviceFilter').on('change', function () {
                        table.search(this.value).draw();
                        $grid.masonry('layout');
                    });
                } else {
                    $('#FacilityListWidget .widget-loading-area').html('<div class="ajax_failed">' + response.msg + '</div>');
                    $('#FacilityListWidget .widget-loading-area').removeClass('d-none');
                    $('#FacilityListWidget .widget-body .loader_wrap').addClass('d-none');
                };
            }).fail(function (XMLHttpRequest, jqXHR, textStatus, errorThrown) {
                // 失敗時処理
                console.log(XMLHttpRequest, jqXHR, textStatus, errorThrown);
                $('#FacilityListWidget .widget-loading-area').html('<div class="ajax_failed">ウィジェットの読み込みに失敗しました。</div>');
                $('#FacilityListWidget .widget-loading-area').removeClass('d-none');
                $('#FacilityListWidget .widget-body .loader_wrap').addClass('d-none')
                return false;
            });
        } else {
            alert('設備リストの読み込みに失敗しました。');
        };
    }).fail(function () {
        // 失敗
        alert('設備リストの読み込みに失敗しました。');
    }).always(function (result) {
    });
};

function SetAjaxFacilityControl(deviceId, prm, ele) {
    ele.find('span').text('設定中...');
    ele.find('.setting-update').removeClass('d-none');
    //JSONオブジェクト設定
    var jsonData = {
        "type": globalDeviceType.device,
        "device_id": deviceId,
        "param": prm,
    };
    $.ajax({
        type: "POST",
        url: "./widget/FacilityListWidget/set_ajax.php",
        data: jsonData,
        dataType: "json",
        timeout: 1000000
    }).done(function (response, textStatus, jqXHR) {
        if (response.state == 'success') {
            // 成功時処理
            ele.find('span').text('設定完了');
            ele.find('.setting-update').addClass('d-none');
            var obj = document.getElementsByName("DeviceListTables_length")[0];
            var idx = obj.selectedIndex;
            var txt = obj.options[idx].text;
            if (isNaN(txt) === true) {
                txt = -1;
            };
            var lists = Array.from(document.querySelectorAll("li"));
            var index = lists.findIndex(list =>
                Array.from(list.classList).includes("active")
            )
            reloadAjaxTable(globalDeviceType.device, txt, index)
            return true;
        } else {
            ele.find('span').text('設定失敗');
            ele.find('.setting-update').addClass('d-none');
            console.log(response.msg);
            return false;
        };
    }).fail(function (XMLHttpRequest, jqXHR, textStatus, errorThrown) {
        // 失敗時処理
        ele.find('span').text('設定失敗');
        ele.find('.setting-update').addClass('d-none');
        console.log(XMLHttpRequest, jqXHR, textStatus, errorThrown);
        return false;
    });
};
