<?php
require_once("../../core/construct.php");
require_once(CORE_PATH."functions.php");
require_once(CORE_PATH."session_check.php");
require_once(SIGNAGE_ROOT."api.php");
require_once(__DIR__ . '/../../util/utils.php');

try{
    if(!isset($_SERVER['HTTP_X_REQUESTED_WITH']) || strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) !== 'xmlhttprequest') {
        throw new Exception('HTTP通信に失敗しました。');
    }
    $POST = filterPost();
    // テキストファイルからデバイスタイプ取得
    $filename =  __DIR__.'/../../../contents/devicetype_'.$_ENV["SITE_NAME"].'.txt';
    $text_open = fopen($filename, 'r');
    $read_text = fread($text_open, filesize($filename));
    $text_split = preg_split ('/^\d*_/',$read_text);
    fclose($text_open);
    $json_data = json_decode($text_split[0], true);
    $res_device_type = $json_data['res_device_type'];
    if(!$res_device_type){
        throw new Exception("デバイスタイプの取得に失敗しました。");
    }
    $DevicetypeListDom = "";
    $Dom = "";
    // 警報件数取得
    $alarm_number = 0;
    $type_count = count($res_device_type);
    // デバイスタイプことにループ
    for($type_counter = 0; $type_counter < $type_count; $type_counter++){
        // テキストファイルからデバイスタイプ情報取得
        $device_filename =  __DIR__.'/../../../contents/devicedata_'.$res_device_type[$type_counter].'_'.$_ENV["SITE_NAME"].'.txt';
        $device_text_open = fopen($device_filename, 'r');
        $read_device_text = fread($device_text_open, filesize($device_filename));
        $device_text_split = preg_split ('/^\d*_/',$read_device_text);
        fclose($device_text_open);
        $text_data = json_decode($device_text_split[0], true);
        $res_device_data = $text_data["res_device_data"];
        $db_device_data_list = $text_data["db_device_data_list"];
        if(!$res_device_data){
            throw new Exception("デバイス情報の取得に失敗しました。");
        }
        if(!$db_device_data_list){
            throw new Exception("DBデータの取得に失敗しました。");
        }
        $device_data_list[$res_device_type[$type_counter]][] = $res_device_data;
        // Dx-Coreからステータス情報取得
        $device_count = count($res_device_data);
        // DX-Coreで取得したデータの数ループ
        for($device_counter = 0; $device_counter < $device_count; $device_counter++){
            $json = (array)$res_device_data[$device_counter];
            $json_count = count($json);
            $json_key = array_keys($json);
            $json_value = array_values($json);
            // １つの機器のファンクションの数ループ
            for($json_counter = 1; $json_counter < $json_count; $json_counter++){
                // 警報件数
                foreach($db_device_data_list as $db_device_data_key => $db_device_data_value){
                    if(($db_device_data_value["alarm_type"] ===  '0' || $db_device_data_value["alarm_type"] ===  '1' || $db_device_data_value["alarm_type"] ===  '2') && ($json_value[$json_counter] === 1) && ($json_key[$json_counter] === $db_device_data_value["device_function"])){
                        $alarm_number = $alarm_number + 1;
                    };
                };
            };
        };
    };
    $ret = [
        'state' => 'success',
        'alarm' => $alarm_number,
    ];
    $log->info('Succeeded in getting the number of alarms.', array('file' => __FILE__, 'user_id' => $_SESSION['login']['user_id'], 'alarm' => $alarm_number));
    header('Content-Type: application/json; charset=utf-8', true);
    echo json_encode($ret);
}catch(Exception $e){
    $ret = [
        'state' => 'error',
        'msg' => $e->getMessage()
    ];
    $log->error($e);
    $log->error('Failed to get the number of alarms.', array('file' => __FILE__, 'user_id' => $_SESSION['login']['user_id'], 'message' => $e->getMessage()));
    header('Content-Type: application/json; charset=utf-8', true);
    echo json_encode($ret);
};
?>
