<?php
require_once("../../core/construct.php");
require_once(CORE_PATH."functions.php");
require_once(CORE_PATH."session_check.php");
require_once(__DIR__ . '/../../util/utils.php');

try{
    $tenant_id = $_SESSION['login']['tenant_id'];

    require_once(SIGNAGE_ROOT."model/model.php");
    $sgMDL = new sngModel($sdb, $link);
    require_once(SUPER_APPLI_ROOT."model/model.php");
    $sapMDL = new sappModel($sdb, $link);
    require_once(ADMIN_ROOT."model/model.php");
    $admMDL = new admModel($sdb, $link);
    require_once(SIGNAGE_ROOT."api.php");
    $API = new Api($tenant_id);
    $POST = filterPost();
    $prm = $POST['param'];
    $devicetype = $POST['type'];
    $device_id = $POST['device_id'];
    if($devicetype == 'ahu'){
        $device_type = DEVICE_TYPE_AIRCON_AHU;
    }elseif($devicetype == 'ohu'){
        $device_type = DEVICE_TYPE_AIRCON_OHU;
    }elseif($devicetype == 'light'){
        $device_type = DEVICE_TYPE_LIGHT;
    }elseif($devicetype == 'vav'){
        $device_type = DEVICE_TYPE_VAV;
    }elseif($devicetype == 'dcu'){
        $device_type = DEVICE_TYPE_AIRCON_DCU;
    }elseif($devicetype == 'fcu'){
        $device_type = DEVICE_TYPE_AIRCON_FCU;
    }elseif($devicetype == 'pac'){
        $device_type = DEVICE_TYPE_PAC;
    };
    if($device_id){
        switch($device_type){
            case DEVICE_TYPE_AIRCON_DCU:
                $put_prm = [
                    'Data'=>[
                    'Device.Info.Id' => (int) $device_id,
                    'Device.Status.RunningControl' => (int) $prm['onoff'],
                    'Device.Status.TempControl' => (float) $prm['Temp'],
                    'Device.Status.AirVolumeControl' => (int) $prm['select'],
                    ]
                ];
                break;
            case DEVICE_TYPE_LIGHT:
                $put_prm = [
                    'Data'=>[
                    'Device.Info.Id' => (int) $device_id,
                    'Device.Status.Lighting' => (int) $prm['light'],
                    ]
                ];
                break;
            case DEVICE_TYPE_VAV:
                $put_prm = [
                    'Data'=>[
                    'Device.Info.Id' => (int) $device_id,
                    'Device.Status.RunningControl' => (int) $prm['onoff'],
                    'Device.Status.TempControl' => (float) $prm['Temp'],
                    ]
                ];
                break;
            case DEVICE_TYPE_AIRCON_FCU:
                $put_prm = [
                    'Data'=>[
                    'Device.Info.Id' => (int) $device_id,
                    'Device.Status.RunningControl' => (int) $prm['onoff'],
                    'Device.Status.TempControl' => (float) $prm['Temp'],
                    'Device.Status.AirVolumeControl' => (int) $prm['select'],
                    'Device.Status.HeatingAndCoolingControl' => (float) $prm['reidan'],
                    ]
                ];
                break;
            case DEVICE_TYPE_AIRCON_AHU:
                $put_prm = [
                    'Data'=>[
                    'Device.Info.Id' => $device_id,
                    'Device.Status.RunningControl' => (int) $prm['onoff'],
                    'Device.Status.SupplyAirTempSetting' => (float) $prm['TempSetting'],
                    'Device.Status.ReturnAirHumiditySetting' => (int) $prm['Humidity'],
                    'Device.Status.CO2Setting' => (int) $prm['co2'],
                    'Device.Status.ModeSetting' => (int) $prm['mode'],
                    ]
                ];
                break;
            case DEVICE_TYPE_AIRCON_OHU:
                $put_prm = [
                    'Data'=>[
                    'Device.Info.Id' => (int) $device_id,
                    'Device.Status.RunningControl' => (int) $prm['onoff'],
                    'Device.Status.SupplyAirTempControl' => (float) $prm['SupplyAirTemp'],
                    ]
                ];
                break;
            case DEVICE_TYPE_PAC:
                $put_prm = [
                    'Data'=>[
                    'Device.Info.Id' => (int) $device_id,
                    'Device.Status.RunningControl' => (int) $prm['onoff'],
                    'Device.Status.TempSetting' => (float) $prm['TmpStt'],
                    'Device.Status.ModeSetting' => (int) $prm['mode'],
                    ]
                ];
                break;
        }
        //デバイスへ設定変更要求を送信
        $put_ret = $API->PutDeviceStatus($_ENV["SITE_NAME"], $device_type, $device_id, $put_prm);
        sleep(3); //更新が早すぎて、値が更新されないため。
    };
    $ret = [
        'state' => 'success',
    ];
    $log->info('Successful configuration change request to the device.', array('file' => __FILE__, 'user_id' => $_SESSION['login']['user_id'], 'device_type' => $device_type, 'device_id' => $device_id, 'put_parameter' => $put_prm['Data']));
    header('Content-Type: application/json; charset=utf-8', true);
    echo json_encode($ret);
}catch(Exception $e){
    $ret = [
        'state' => 'error',
        'msg' => $e->getMessage(),
    ];
    $log->error($e);
    $log->error('Failed configuration change request to device.', array('file' => __FILE__, 'user_id' => $_SESSION['login']['user_id'], 'device_type' => $device_type, 'device_id' => $device_id, 'put_parameter' => $put_prm['Data'], 'message' => $e->getMessage()));
    header('Content-Type: application/json; charset=utf-8', true);
    echo json_encode($ret);
}
?>
