<?php

require("../../core/construct.php");
require(CORE_PATH."functions.php");
require(CORE_PATH."session_check.php");
require_once(__DIR__."/../../util/utils.php");

try{
    require(SIGNAGE_ROOT."model/model.php");
    $sgMDL = new sngModel($sdb, $link);
    require(SUPER_APPLI_ROOT."model/model.php");
    $sapMDL = new sappModel($sdb, $link);
    require(ADMIN_ROOT."model/model.php");
    $admMDL = new admModel($sdb, $link);

    $POST = filterPost();

    if(!isset($_SERVER['HTTP_X_REQUESTED_WITH']) || strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) !== 'xmlhttprequest') {
        throw new Exception('接続が安全ではありません。');
    }

    $duid = $POST['duid'];
    $user_id = $_SESSION['login']['user_id'];
    $tenant_id = $_SESSION['login']['tenant_id'];

    $u_row = $sapMDL->GetUserInfo($user_id);
    if(!$u_row) throw new Exception('ユーザー情報の読み込みが失敗しました。');
    $device_auth = explode(",", $u_row['device_authorize']);

    $AllDeviceList = $sgMDL->GetDeviceTblByTenantIDControlable($tenant_id, $device_auth);
    if(!in_array($duid, $device_auth)){
        $dom = <<<EOM
            <div class="control-area no-result">
                <div class="pt10 pb10">操作可能な端末ではありません。</div>
            </div>
        EOM;
        $ret = [
            'state' => 'success',
            'html' => $dom,
        ];
        header('Content-Type: application/json; charset=utf-8', true);
        echo json_encode($ret);
        exit;
    }

    //TODO 過去に操作した空調デバイスIDをウィジェット設定から取得し、情報をデータベースより取得。
    $deviceData = [];
    $d_row = $sgMDL->GetDeviceTblByDeviceUniqID($duid);
    $deviceData = $d_row;

    //TODO 第三者APIからデバイスの状態を取得
    require(SIGNAGE_ROOT."api.php");
    $API = new Api($tenant_id);

    $res = $API->GetTenantName();
    $sitename = $res->Data->{'General.SiteList'}[0];

    $dinfo = $API->GetDeviceStatus($sitename, $deviceData['type'], $deviceData['device_id']);
    $dd = $dinfo->Data;
    $deviceData['running'] = (isset($dd->{'Device.Status.Lighting'}))?$dd->{'Device.Status.Lighting'}:0;
    $runninged = ($deviceData['running'] == 1)?"checked":"";
    $onoff = ($deviceData['running'] == 1)?"ON":"OFF";
    $widget = "LightDeviceControllWidget";

    if(!empty($deviceData)){
        $dom = <<<EOM
            <div class="control-area" data-type="light">
                <form onsubmit="return false;">
                    <div class="device-control-title">
                        照明設定 - <span class="title-devicename">{$deviceData['name']}</span>
                    </div>
                    <div class="device-wrap-box air-device-wrap">
                        <input type="hidden" id="ControllAreaId_{$deviceData['du_id']}" />
                        <span class="svg-wrap device-icon">
                            <svg class="img-fluid wh100px">
                                <use xlink:href="./widget/{$widget}/img/light.svg#Light"></use>
                            </svg>
                        </span>
                        <div class="control-box">
                            <input type="hidden" name="init_powerstatus" value="{$deviceData['example']}" />
                            <div class="d-flex justify-content-center justify-content-lg-left">
                                <div class="control-group devicecon-powerswitch d-flex">
                                    <p class="device-state w100">電源：<span>{$onoff}</span></p>
                                    <div class="custom-control custom-switch">
                                        <input type="checkbox" class="custom-control-input" id="ModalLightAreaSetting" name="powerstatus" {$runninged}>
                                        <label class="custom-control-label" for="ModalLightAreaSetting"></label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="device-control-footer">
                        <button data-duid="{$deviceData['du_id']}" class="devcon_btn device-setting-submit">
                            <div class="device-setting-update d-none">
                                <div class="loader_inner">
                                    <div class="circle_loader">Loading...</div>
                                </div>
                            </div>
                            <span>設定</span>
                        </button>
                </form>
            </div>
        EOM;
    }else{
        $dom = <<<EOM
            <div class="control-area no-result">
                <div class="pt10 pb10">最後に操作した端末は存在しません。
                    <button class="devcon_btn" data-toggle="modal" data-target="#modal-deviceselect-light">他の端末を選ぶ</button>
                </div>
        </div>
        EOM;
    }
    $ret = [
        'state' => 'success',
        'html' => $dom,
    ];

    // 照明デバイス状態情報取得成功時ログ(モーダル内)
    $log->info('Successful light device status load.(modal)',
        array('file' => __FILE__, 'user_id' => $user_id)
    );

    header('Content-Type: application/json; charset=utf-8', true);
    echo json_encode($ret);
}catch(Exception $e){
    $ret = [
        'state' => 'error',
        'msg' => $e->getMessage(),
    ];
    $mes = GetMsgEncode($e->getMessage());

    // 照明デバイス状態情報取得失敗時(モーダル内)
    $log->info($e);
    $log->info('Failed to light device status load.(modal)',
        array(
            'file' => __FILE__,
            'user_id' => $user_id,
            'message' => $e->getMessage()
        )
    );

    header('Content-Type: application/json; charset=utf-8', true);
    echo json_encode($ret);
}
?>
