<?php

require("../../core/construct.php");
require(CORE_PATH."functions.php");
require(CORE_PATH."session_check.php");
require_once(__DIR__ . "/../../util/utils.php");

try{
    require(SIGNAGE_ROOT."model/model.php");
    $sgMDL = new sngModel($sdb, $link);

    require(SUPER_APPLI_ROOT."model/model.php");
    $sapMDL = new sappModel($sdb, $link);

    require(ADMIN_ROOT."model/model.php");
    $admMDL = new admModel($sdb, $link);


    $POST = filterPost();

    if(!isset($_SERVER['HTTP_X_REQUESTED_WITH']) || strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) !== 'xmlhttprequest') {
        throw new Exception('接続が安全ではありません。');
    }

    $duid = $POST['duid'];
    $prm = $POST['param'];
    $user_id = $_SESSION['login']['user_id'];
    $tenant_id = $_SESSION['login']['tenant_id'];

    $d_row = $sgMDL->GetDeviceTblByDeviceUniqID($duid);
    if(!$d_row) throw new Exception('指定された端末は存在しません。');

    $u_row = $sapMDL->GetUserInfo($user_id);
    if(!$u_row) throw new Exception('ユーザー情報の読み込みが失敗しました。');
    $device_auth = explode(",", $u_row['device_authorize']);

//     $AllDeviceList = $sgMDL->GetDeviceTblByTenantIDControlable($tenant_id, $device_auth);
    if(!in_array($duid, $device_auth)) throw new Exception('操作可能な端末ではありません。');



    //最後に操作したウィジェットIDを保存
    $uw_row = $sapMDL->GetUserWidgetControl($user_id);

    // ウィジェット情報の取得
    $widget_id = "LightDeviceControllWidget";
    $uwid_row = $sapMDL->GetWidgetDataForID($widget_id);
    if(!$uwid_row) throw new Exception('お気に入り登録に失敗しました。');

    if(!$uw_row){
        //使用可能なウィジェットリストのダウンロード
        $WidgetList = $sapMDL->GetWidgetList();
        foreach($WidgetList as $wdK => $wdV){
            //             $is_sub = ($wdV['sub_widget'] == 1)?True:False;

            $widgetsetting[$wdK] = [
                'num' => $wdV['num'],
                'sub' => $wdV['sub_widget'].'',
                'param' => [
                    'id' => ($uwid_row['num'] == $wdV['num'])?$duid:'',
                    'widgetname' => ($uwid_row['num'] == $wdV['num'])?$d_row['name']:'',
                ],
                'flag' => WIDGET_STATUS_ENABLE,
            ];
        }

        $flag_json = $widgetsetting;
    }else{

        $flag_json = $uw_row['flag_json'];
        $flag_json = json_decode($flag_json, true);

//         $arr_len = count($flag_json);
        $keyIndex = array_search($uwid_row['num'], array_column($flag_json, 'num'));
//         $result = $flag_json[$keyIndex];

        $j_key = ($keyIndex !== FALSE)?$keyIndex:NULL;

        if($keyIndex !== FALSE){

            $flag_json[$keyIndex] = [
                'num' => $uwid_row['num'],
                'sub' => '',
                'param' => [
                    'id' => $duid,
                    'widgetname' => $d_row['name'],
                ],
                'flag' => WIDGET_STATUS_ENABLE,
            ];
        }else{
            $flag_json[] = [
                'num' => $uwid_row['num'],
                'sub' => '',
                'param' => [
                    'id' => $duid,
                    'widgetname' => $d_row['name'],
                ],
                'flag' => WIDGET_STATUS_ENABLE,
            ];
        }

//         foreach($flag_json as $fjK => $fjV){

//             if($fjV['num'] == $uwid_row['num']){

//                 $flag_json[$fjK]['param']['id'] = $d_row['du_id'];
//                 $flag_json[$fjK]['param']['widgetname'] = $d_row['name'];
//             }
//         }
    }

    $t = new Datetime();
    $uw_prm = [
        'user_id' => $user_id,
        'flag_json' => json_encode($flag_json),
        'last-update' => $t->format("Y-m-d H:i:s")
    ];

    if($uw_row){
        //上書き
        $up_ret = $sapMDL->UpdateUserWidgetControl($uw_prm);
        if(!$up_ret) throw new Exception('最後に操作されたウィジェットの情報の更新に失敗しました。');
    }else{
        //新規登録
        $ins_ret = $sapMDL->InsertUserWidgetControl($uw_prm);
        if(!$ins_ret) throw new Exception('最後に操作されたウィジェットの情報の登録に失敗しました。');
    }


    //BECSSに端末情報を送信
    require(SIGNAGE_ROOT."api.php");
    $API = new Api($tenant_id);

    $res = $API->GetTenantName();
    $sitename = $res->Data->{'General.SiteList'}[0];

    $devicetype = $prm['type'];

    $res_stt = $API->GetDeviceStatus($sitename, $devicetype, $d_row['device_id']);
    if($res_stt->error) throw new Exception('デバイスが存在しません。');

    switch($devicetype){
        case DEVICE_TYPE_LIGHT:
            $put_prm = [
            'Data'=>[
//            'User.Uuid' => 'testuser@test.com',
            'Device.Info.Id' => $d_row['device_id'],
            'Device.Status.Lighting' => $prm['power'],
            ]
            ];
            break;
    }

    // 照明デバイス状態変更開始ログ
    $log->info('Starting light device status change.',
        array(
            'file' => __FILE__,
            'user_id' => $user_id,
            'site_name' => $sitename,
            'device_type' => $devicetype,
            'device_id' => $d_row['device_id'],
            'put_parameter' => $put_prm
        )
    );


    //デバイスへ設定変更要求を送信
    $put_ret = $API->PutDeviceStatus($sitename, $devicetype, $d_row['device_id'], $put_prm);
//     var_dump($put_ret);exit;

    $ret = [
        'state' => 'success',
    ];


    // 照明デバイス状態変更成功ログ
    $log->info('Successful light device status change.',
        array(
            'file' => __FILE__,
            'user_id' => $user_id,
            'site_name' => $sitename,
            'device_type' => $devicetype,
            'device_id' => $d_row['device_id'],
            'put_parameter' => $put_prm
        )
    );

    header('Content-Type: application/json; charset=utf-8', true);
    // $ret = array(1 => );
    echo json_encode($ret);


}catch(Exception $e){

    $ret = [
        'state' => 'error',
        'msg' => $e->getMessage(),
    ];
    $mes = GetMsgEncode($e->getMessage());

    // 照明デバイス状態変更失敗ログ
    $log->info($e);
    $log->info('Failed to light device status change.',
        array(
            'file' => __FILE__,
            'user_id' => $user_id,
            'site_name' => $sitename,
            'device_type' => $devicetype,
            'device_id' => $d_row['device_id'],
            'put_parameter' => $put_prm,
            'message' => $e->getMessage()
        )
    );

    header('Content-Type: application/json; charset=utf-8', true);
    echo json_encode($ret);
}
?>