<?php
require_once(__DIR__ . "/../../util/utils.php");
require("../../core/construct.php");
require(CORE_PATH."functions.php");
require(CORE_PATH."session_check.php");

$news_limit = 3;

try{
    if(!isset($_SERVER['HTTP_X_REQUESTED_WITH']) || strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) !== 'xmlhttprequest') {
        throw new Exception('接続が安全ではありません。');
    }

    $filename =  __DIR__.'/../../../contents/news.txt';
    $fp = fopen($filename, 'a+');
    $contents = fread($fp, filesize($filename));
    $ret = preg_split ('/^\d*_/',$contents);
    $flag = fclose($fp);

    $rawData = $ret[1];
//     $rawData = '{"status":"ok","totalResults":70,"articles":[{"source":{"id":null,"name":"Nhk.or.jp"},"author":null,"title":"西武ハイヤー 雇用調整助成金の一部 会社の特別利益として計上 - NHK NEWS WEB","description":"私鉄大手、西武ホールディングスの傘下の「西武ハイヤー」が、国から受け取った雇用調整助成金の一部を休業手当にあてず、差額の…","url":"https://www3.nhk.or.jp/news/html/20210419/k10012983151000.html","urlToImage":"https://www3.nhk.or.jp/news/html/20210419/K10012983151_2104191258_2104191302_01_02.jpg","publishedAt":"2021-04-19T06:24:06Z","content":""},{"source":{"id":null,"name":"Impress.co.jp"},"author":null,"title":"楽天モバイルから「Rakuten BIG s」、ミリ波対応で4眼カメラ搭載 - ケータイ Watch","description":"楽天モバイルは、同社オリジナルのAndroidスマートフォン「Rakuten BIG s」を4月21日から順次発売する。価格は5万980円（税込）。","url":"https://k-tai.watch.impress.co.jp/docs/news/1319551.html","urlToImage":"https://k-tai.watch.impress.co.jp/img/ktw/list/1319/551/sub.png","publishedAt":"2021-04-19T05:40:20Z","content":"AndroidRakuten BIG s4215980 \r\n Rakuten BIG s6.4EL48MP45GeSIM \r\n 28MP8MP48MP2MP2020Rakuten BIG \r\n Rakuten Browser \r\n 34215 \r\n 56"},{"source":{"id":null,"name":"Itmedia.co.jp"},"author":"ITmedia","title":"COCOA元請けのパーソルP&Tが1200万円自主返納 対応に疑問の声も - ITmedia","description":"接触確認アプリ「COCOA」の不具合を巡り、アプリ開発の元請けであるパーソルプロセス&テクノロジー（パーソルP&T、東京都江東区）が受託金額の一部を自主返納すると発表。これに対し、Twitterでは疑問の声が上がっている。","url":"https://www.itmedia.co.jp/news/articles/2104/19/news099.html","urlToImage":"https://image.itmedia.co.jp/news/articles/2104/19/cover_news099.jpg","publishedAt":"2021-04-19T05:32:00Z","content":"COCOA&amp;P&amp;T4161200\r\n2020539000COCOAFIXER\r\n4Android\r\nCopyright © ITmedia, Inc. All Rights Reserved."},{"source":{"id":null,"name":"Nikkei.com"},"author":"日本経済新聞社","title":"輸出の中国比率、初の2割超 米中対立がリスクに - 日本経済新聞","description":"財務省が19日発表した2020年度の貿易統計速報は、輸出入で中国への依存を強める日本経済の現状を映した。輸出に占める中国向けの比率は22.9%と初めて2割を超えて米国を抜き、10年ぶりに過去最高を更新した。深刻化する米中対立が貿易取引に波及すれば、新型コロナウイルス禍からの景気回復を阻むリスクになりかねない。20年度の輸出は全体で8.4%減の69兆4873億円。米リーマン危機後だった09年度の","url":"https://www.nikkei.com/article/DGXZQOUA181JM0Y1A410C2000000/","urlToImage":"https://article-image-ix.nikkei.com/https%3A%2F%2Fimgix-proxy.n8s.jp%2FDSXZQO0520129019042021000000-1.jpg?auto=format%2Ccompress&ch=Width%2CDPR&q=45&fit=crop&bg=FFFFFF&w=1200&h=630&fp_x=0.5&fp_y=0.5&fp_z=1&crop=focalpoint&ixlib=js-1.4.1&s=a956eee6cf173d169c446c3b8cb57620","publishedAt":"2021-04-19T05:00:00Z","content":null},{"source":{"id":null,"name":"Bloomberg.co.jp"},"author":null,"title":"米国債、弱気派には厳しい環境－10年物利回り1.2％に低下の観測も - ブルームバーグ","description":"米国債の下落を見込むポジションを構築したり現金に退避して値下がりを待っている投資家にとって先週は、経済指標が米景気回復の勢いを示したにもかかわらず、厳しい１週間だった。","url":"https://www.bloomberg.co.jp/news/articles/2021-04-19/QRSE91T1UM1E01","urlToImage":"https://assets.bwbx.io/images/users/iqjWHBFdfxIU/imD2Wxz_vY2Q/v2/-1x-1.png","publishedAt":"2021-04-19T04:43:19Z","content":"米国債の下落を見込むポジションを構築したり現金に退避して値下がりを待っている投資家にとって先週は、経済指標が米景気回復の\r\n勢いを示したにもかかわらず、厳しい１週間だった。\r\n　　米国債の先行きを巡る議論は、終わったというには\r\n程遠い。2021年に入って主流だった弱気な見方は先週、週ベースで昨年８月以来の大幅値上がりから打撃を受けた。利回りが一時的にさらに低下する可能性を指摘するストラテジスト… [+1186 chars]"},{"source":{"id":null,"name":"Rocketnews24.com"},"author":"https://www.facebook.com/neko.ahiru.1","title":"【速報】松屋の「ごろチキ」が復活！ 繰り返す、松屋の「ごろごろ煮込みチキンカレー」が復活だァァァァアアア!! 4月27日から！ - ロケットニュース24","description":"速報ォォォォオオオオ！　とんでもねぇ速報だァァァァァアアアアア!!    松屋の「ごろチキ」が復活ッ！　松屋の「ごろチキ」が復活ッ!!　松屋の「ごろチキ」が復活ッ！　 …","url":"https://rocketnews24.com/2021/04/19/1481889/","urlToImage":"https://rocketnews24.com/wp-content/uploads/sites/2/2019/10/014.jpg?w=1200&h=630&crop=1","publishedAt":"2021-04-19T04:34:32Z","content":null},{"source":{"id":null,"name":"Itmedia.co.jp"},"author":"ITmedia","title":"血中酸素酸素レベル測れるスマートウォッチ「OPPO Band Style」4480円で登場 - ITmedia","description":"血中酸素酸素レベル測定機能などを備えた多機能スマートウォッチ「OPPO Band Style」が登場。4480円（税込）と低価格だ。","url":"https://www.itmedia.co.jp/news/articles/2104/19/news088.html","urlToImage":"https://image.itmedia.co.jp/news/articles/2104/19/cover_news088.jpg","publishedAt":"2021-04-19T04:07:00Z","content":"OPPOOPPO Band Style4234480\r\nSpO2\r\n24\r\n12OPPO Band Style5\r\nAndroid\r\n1210.3g2\r\nCopyright © ITmedia, Inc. All Rights Reserved."},{"source":{"id":null,"name":"Nikkei.com"},"author":"日本経済新聞社","title":"株、上値抑える現物への売り 日経先物、下落するのは東京タイム - 日本経済新聞","description":"日経平均株価の上値が重い。連日で最高値を更新する米ダウ工業株30種平均とは対照的だ。大阪取引所でほぼ一日中取引される日経平均先物の動きを東京と海外の取引時間帯で分けてみると、東京タイムでの下げが目立つ。東証の取引時間と重なり、現物株に売りが出ている証左といえる。国内外の年金基金からの売りなどが上値を抑える要因とみられている。日経平均の19日午前の終値は前週末比64円高の2万9748円だった。プ","url":"https://www.nikkei.com/article/DGXZASFL19HCR_Z10C21A4000000/","urlToImage":"https://article-image-ix.nikkei.com/https%3A%2F%2Fimgix-proxy.n8s.jp%2FDSXZQO0519396019042021000000-1.jpg?auto=format%2Ccompress&ch=Width%2CDPR&q=45&fit=crop&bg=FFFFFF&w=1200&h=630&fp_x=0.5&fp_y=0.5&fp_z=1&crop=focalpoint&ixlib=js-1.4.1&s=3f5d5f5919fc88dced69cd34c7ffb445","publishedAt":"2021-04-19T03:52:00Z","content":null},{"source":{"id":null,"name":"Impress.co.jp"},"author":null,"title":"ドコモショップでahamoの有償サポート、22日から3300円で開始予定 - ケータイ Watch","description":"NTTドコモは、4月22日からオンライン専用料金プラン「ahamo」のドコモショップでの有償サポートを提供する予定を明らかにした。料金は1回3300円（税込）の見込み。","url":"https://k-tai.watch.impress.co.jp/docs/news/1319483.html","urlToImage":"https://k-tai.watch.impress.co.jp/img/ktw/list/1319/483/sub.png","publishedAt":"2021-04-19T03:51:20Z","content":"Copyright ©2018Impress Corporation. All rights reserved."},{"source":{"id":null,"name":"Kuruma-news.jp"},"author":null,"title":"ホンダが新型電動SUVを世界初公開！ 上海で「eプロトタイプ」を発表 発売は2022年春 - くるまのニュース","description":"ホンダは2021年4月19日に、中国の上海で開催中の「2021年 上海モーターショー」において、中国初となるホンダブランドの電気自動車プロトタイプ「Honda SUV e:prototype（ホンダ・エスユーブイ・イー・プロトタイプ）」を世界初公開しました。","url":"https://kuruma-news.jp/post/368369","urlToImage":"https://kuruma-news.jp/wp-content/uploads/2022/04/20210419_honda_eprototype_004.jpg?v=1618803543","publishedAt":"2021-04-19T03:47:39Z","content":"20214192021 Honda SUV e:prototype\r\nSUV\r\n20214192021 SUVHonda SUV e:prototypee\r\n2022SUVe\r\ne2022510EV\r\n2050e\r\ne\r\nOTA3 Honda CONNECTFUN2021\r\nHonda CONNECT\r\nAIOTA\r\nCR-VPHEV\r\nPHEV2SPORT HYBRID i-MMD\r\nEVEV… [+18 chars]"},{"source":{"id":null,"name":"Gizmodo.jp"},"author":"塚本直樹","title":"ついに出る？ アップル純正MagSafe対応モバイルバッテリー - GIZMODO JAPAN","description":"Apple（アップル）純正のMagSafe対応モバイルバッテリーかもしれない画像が、ツイッター上に投稿されています。","url":"https://www.gizmodo.jp/2021/04/magsafe-battery-designed-by-california.html","urlToImage":"https://assets.media-platform.com/gizmodo/dist/images/2021/04/19/Ey_Wu_7VoAQr046-w960.jpeg","publishedAt":"2021-04-19T03:30:00Z","content":"Copyright © mediagene Inc. All Rights Reserved."},{"source":{"id":null,"name":"Response.jp"},"author":"纐纈敏也＠DAYS","title":"日産 エクストレイル 新型発表、2021年下期に市場投入…上海モーターショー2021 - レスポンス","description":"日産自動車は4月19日、上海モーターショー2021の出展概要を発表。新型『エクストレイル』や新型クロスオーバーEV『アリア』など、最先端の技術や高度なコネクティビティを搭載した多彩なラインアップを出展する。","url":"https://response.jp/article/2021/04/19/345106.html","urlToImage":"https://response.jp/imgs/ogp_f/1626177.jpg","publishedAt":"2021-04-19T03:27:45Z","content":null},{"source":{"id":null,"name":"Yahoo.co.jp"},"author":"時事通信","title":"支払日にATMで現金化 給与デジタル払いで制度案 厚労省（時事通信） - Yahoo!ニュース - Yahoo!ニュース","description":"スマートフォンの決済アプリに給与が直接入金される「デジタル払い」の解禁に向け、厚生労働省は19日、労働政策審議会（厚労相の諮問機関）の分科会に制度設計案の骨子を示した。骨子によると、デジタル払いで","url":"https://news.yahoo.co.jp/articles/0e3426cf1e5717418b795c266067b85cb381a84c","urlToImage":"https://amd-pctr.c.yimg.jp/r/iwiz-amd/20210419-00000046-jij-000-6-view.jpg","publishedAt":"2021-04-19T03:23:34Z","content":null},{"source":{"id":null,"name":"Yahoo.co.jp"},"author":"STVニュース北海道","title":"最初は「名前の頭文字」で制限 コストコ石狩２２日オープン（STVニュース北海道） - Yahoo!ニュース - Yahoo!ニュース","description":"会員制の大型倉庫型店舗を展開する「コストコ」の北海道内２号店が、石狩市にオープンします。\n\n２２日のオープンを前に一足早く売り場が公開されました。\n\n（村雨アナウンサー）「倉庫型の広い店舗には、コス","url":"https://news.yahoo.co.jp/articles/4a08fb7c1fc2b8fe77ae8bdb3a09224e4a43d060","urlToImage":"https://amd-pctr.c.yimg.jp/r/iwiz-amd/20210419-00218685-stv-000-1-thumb.jpg","publishedAt":"2021-04-19T03:23:08Z","content":null},{"source":{"id":null,"name":"Impress.co.jp"},"author":null,"title":"レクサス、新型「ES」を世界初公開 日本での発売は2021年秋ごろを予定 - Car Watch","description":"レクサス（トヨタ自動車）は4月19日、新型「ES」を「上海モーターショー2021」で世界初公開した。日本での発売は2021年秋ごろを予定している。","url":"https://car.watch.impress.co.jp/docs/rank/1319422.html","urlToImage":"https://car.watch.impress.co.jp/img/car/list/1319/422/000.jpg","publishedAt":"2021-04-19T03:17:41Z","content":"Copyright ©2018Impress Corporation. All rights reserved."},{"source":{"id":null,"name":"Response.jp"},"author":"森脇稔","title":"トヨタとスバルの共同開発EV『bZ4X』発表、2022年発売へ…上海モーターショー2021 - レスポンス","description":"◆ダイハツとスズキもbZ4Xに続くEVの共同開発プロジェクトに参画◆EV専用プラットフォーム◆スバルと共同開発した新AWDシステム","url":"https://response.jp/article/2021/04/19/345105.html","urlToImage":"https://response.jp/imgs/ogp_f/1626195.jpg","publishedAt":"2021-04-19T03:16:16Z","content":"Toyota4192021EVbZ4X\r\n2025EV15EVbZbZ7\r\nEVbZEVEVbZbeyond ZeroZero Emission\r\nbZ4XEV\r\nbZ4XEVEV\r\nbZEV1SUBARUBYD\r\nCO2 bZ4X\r\nEV\r\nbZ4XbZEVSUVEV86BRZbZ4Xe-TNGAEVAWDEV\r\nbZ4XEVD\r\n bZ4X\r\nAWD\r\nAWD\r\nbZ4XEV\r\nbZ4X20… [+1 chars]"},{"source":{"id":null,"name":"Impress.co.jp"},"author":null,"title":"mineo、20日から「AQUOS sense5G」「Redmi 9T」「moto g30」など5端末を発売 - ケータイ Watch","description":"オプテージは、MVNO型通信サービス「mineo」で、Xiaomi（シャオミ）製の「Redmi 9T」、シャープ製の「AQUOS sense5G」、モトローラ製の「moto g30」と「moto e7」のスマートフォン4端末と、レノボ製タブレット「Lenovo Tab M8」を4月20日に発売開始する。","url":"https://k-tai.watch.impress.co.jp/docs/news/1319485.html","urlToImage":"https://k-tai.watch.impress.co.jp/img/ktw/list/1319/485/mineo.jpg","publishedAt":"2021-04-19T03:14:06Z","content":"MVNOmineoXiaomiRedmi 9TAQUOS sense5Gmoto g30moto e74Lenovo Tab M8420 \r\n Redmi 9T16368682×24AQUOS sense5G464641936×24moto g3022968957×24moto e716104671×24Lenovo Tab M823760990×24 \r\n 4mineoNTTauLenovo … [+250 chars]"},{"source":{"id":null,"name":"Yahoo.co.jp"},"author":"スポーツ報知","title":"梅宮アンナ、眉アートメイクした一人娘・百々果さんと２ショット「美人親子」「大人の女性に」（スポーツ報知） - Yahoo!ニュース - Yahoo!ニュース","description":"タレントの梅宮アンナ（４８）が１９日までに自身のインスタグラムを更新。一人娘の百々果さん（１９）との親子ショットを公開した。\n\n　アンナは「東京に戻った私は、久々にももかとネイルへ」とつづり、おそ","url":"https://news.yahoo.co.jp/articles/7880a7b80311b43c62a084903bb9ff4ddbe71b32","urlToImage":"https://amd-pctr.c.yimg.jp/r/iwiz-amd/20210419-04191008-sph-000-3-view.jpg","publishedAt":"2021-04-19T03:10:05Z","content":"- - - - - - - - Copyright © 2021 The Hochi Shimbun. \r\n©Yahoo Japan"},{"source":{"id":null,"name":"Impress.co.jp"},"author":null,"title":"セブンアプリにPayPay登録で半額クーポン毎週5枚 - Impress Watch","description":"セブン-イレブン・ジャパンとPayPayは、「セブン-イレブンアプリ」にPayPayを登録すると、5週連続で対象商品の半額クーポンを5枚配布するキャンペーンを、4月28日から5月27日まで実施する。クーポンは毎週水曜日と木曜日に配布され、入手するためには前週の火曜日の時点で「セブン-イレブンアプリ」にPayPayを登録している必要がある。各クーポンは1人1枚限り。","url":"https://www.watch.impress.co.jp/docs/news/1319461.html","urlToImage":"https://www.watch.impress.co.jp/img/ipw/list/1319/461/paypay01_3x2.jpg","publishedAt":"2021-04-19T02:57:10Z","content":"-PayPay-PayPay55428527-PayPay11 \r\n --1"},{"source":{"id":null,"name":"Kuruma-news.jp"},"author":null,"title":"SUVのトヨタ「クラウン」世界初公開！ 新型「クラウンクルーガー」2021年中頃に中国で発売！ - くるまのニュース","description":"トヨタは上海モーターショー2021で、新型「クラウンクルーガー」と新型「ハイランダー」を世界初公開しました。この2台の3列シートSUVは2021年中頃に中国で発売される予定です。","url":"https://kuruma-news.jp/post/368387","urlToImage":"https://kuruma-news.jp/wp-content/uploads/2022/04/20210419_toyota_crownkluger_003.jpg?v=1618799783","publishedAt":"2021-04-19T02:49:49Z","content":"Copyright © mediavague Co., ltd.All Rights Reserved."}]}';

    $jsonData = json_decode($rawData);

    if($jsonData->status !== "ok"){
        throw new Exception('利用できるニュースはありません。');
    }


    foreach($jsonData->articles as $nwsK => $nwsV){
        if(count($newsList) >= $news_limit) continue;

        $t = new Datetime();
        $t->setTimestamp(strtotime($nwsV->publishedAt))->setTimezone(new DateTimeZone('Asia/Tokyo'));

//         $t = new Datetime($nwsV->publishedAt);
//         $t->setTimezone('Asia/Tokyo');

        $newsList[] = array(
            'date'=>$t->format("Y-m-d H:i:s"),
            'sender'=>$nwsV->author,
            'title'=>$nwsV->title,
            'text'=>$nwsV->description,
            'link'=>$nwsV->url,
        );
    }



    $dom = "";
    if($newsList){
        foreach($newsList as $nlK => $nlV){
            $dom .= "<article class=\"news\">";
            $dom .= "<a href=\"".$nlV['link']."\" class=\"d-flex\" target=\"_blank\">";
            $dom .= "<div class=\"news-date\">".$nlV['date']."</div>";
            $dom .= "<div class=\"news-sender\">".$nlV['sender']."</div>";
            $dom .= "<div class=\"news-title w100\">".$nlV['title']."</div>";
            $dom .= "<div class=\"news-text w100\">".$nlV['text']."</div>";
            $dom .= "</a>";
            $dom .= "</article>";
        }
    }else{
        $dom .= "<article><div class=\"brank-news\">取得できるニュースはありません。</div></article>";
    }

    // echo $dom;

    $ret = [
        'state' => 'success',
        'html' => $dom,
    ];

    //ニュース情報読み込み成功ログ
    $log->info('Successful news information load.',
        array('file' => __FILE__, 'user_id' => $_SESSION['login']['user_id'])
    );

    header('Content-Type: application/json; charset=utf-8', true);
    // $ret = array(1 => );
    echo json_encode($ret);


}catch(Exception $e){

    $ret = [
        'state' => 'error',
        'msg' => $e->getMessage(),
    ];
    $mes = GetMsgEncode($e->getMessage());

    //ニュース情報読み込み失敗ログ
    $log->info($e);
    $log->info('Failed to news information load.',
        array(
            'file' => __FILE__,
            'user_id' => $_SESSION['login']['user_id'],
            'message' => $e->getMessage()
        )
    );

    header('Content-Type: application/json; charset=utf-8', true);
    echo json_encode($ret);
}
?>