<?php
require("../../core/construct.php");
require(CORE_PATH."functions.php");
require(CORE_PATH."session_check.php");
require_once(__DIR__ . "/../../util/utils.php");


try{
    require(SUPER_APPLI_ROOT."model/model.php");
    $sapMDL = new sappModel($sdb, $link);

    // user_idの取得
    $user_id = $_SESSION['login']['user_id'];

    if(!isset($_SERVER['HTTP_X_REQUESTED_WITH']) || strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) !== 'xmlhttprequest') {
        throw new Exception('接続が安全ではありません。');
    }

    $POST = filterPost();


    // お知らせ情報削除開始ログ
    $log->info('Starting notification information delete.',
        array(
            'file' => __FILE__,
            'user' => $user_id,
            'id' => $POST['id']
        )
    );

    // DBからお知らせ通知情報を削除する。
    $u_row = $sapMDL->DeleteNotificationInfo($POST['id']);
    if(!$u_row){
        throw new Exception('削除できるお知らせ情報がありません。');
    }

    // レスポンス
    $ret = [
        'state' => 'success',
        'html' => $dom,
        'id' => $POST['id']
    ];

    // お知らせ情報削除成功ログ
    $log->info('Successful notification information delete',
    array(
        'file' => __FILE__,
        'user_id' => $user_id,
        'id' => $POST['id']
    ));

    header('Content-Type: application/json; charset=utf-8', true);
    echo json_encode($ret);

}catch(Exception $e){

    $ret = [
        'state' => 'error',
        'msg' => $e->getMessage(),
    ];
    $mes = GetMsgEncode($e->getMessage());

    // お知らせ情報削除失敗ログ
    $log->info($e);
    $log->info('Failed to notification information delete.',
        array(
            'file' => __FILE__,
            'user_id' => $user_id,
            'id' => $POST['id'],
            'message' => $e->getMessage()
        )
    );

    header('Content-Type: application/json; charset=utf-8', true);
    echo json_encode($ret);
}
?>
