<?php
require("../../core/construct.php");
require(CORE_PATH."functions.php");
require(CORE_PATH."session_check.php");
require_once(__DIR__ . "/../../util/utils.php");

try{
    require(SUPER_APPLI_ROOT."model/model.php");
    $sapMDL = new sappModel($sdb, $link);

    if(!isset($_SERVER['HTTP_X_REQUESTED_WITH']) || strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) !== 'xmlhttprequest') {
        throw new Exception('接続が安全ではありません。');
    }

    // user_idの取得
    $user_id = $_SESSION['login']['user_id'];

    // DBからお知らせ通知情報を取得する。
    $u_row = $sapMDL->GetNotificationInfo($user_id);

    // 配列の中身を判別
    if(empty($u_row)){
        $u_row = [];
    }

    // html作成
    $dom = "";
    if($u_row){
        // お知らせを降順に並べ替え
        $u_row = array_reverse($u_row);
        foreach($u_row as $nlK => $nlV){
            $dom .= "<article class=\"notification_".$nlV['id']."\">";
            $dom .= "<div id=\"notification-square_btn_".$nlV['id']."\" onclick=\"clickNotificationDelete(".$nlV['id'].")\">×</div>";
            // 時刻
            $dom .= "<div class=\"notification-date_".$nlV['id']."\">".$nlV['datetime']."</div>";
            // 機能
            // $dom .= "<div class=\"notification-sender\">".$nlV['function']."</div>";
            $dom .= "<div calss=\"notification-swich_".$nlV['id']."\">";
            $dom .= "<input id=\"switch_".$nlV['id']."\" type=\"checkbox\">";
            $dom .= "<label class=\"button_".$nlV['id']."\" for=\"switch_".$nlV['id']."\">";
            $dom .= "<span class=\"icon_".$nlV['id']."\"></span>";
            // タイトル
            $dom .= "<span class=\"open_".$nlV['id']."\"><div class=\"notification-title_".$nlV['id']." w100\">".$nlV['title']."</div></span>";
            $dom .= "</label>";
            // テキスト
            $dom .= "<div class=\"notification-text_".$nlV['id']." w100\"><p>".preg_replace('/\n|\r|\r\n/', '<br>' ,$nlV['description'])."</p></div>";
            // お知らせの個数に応じてウィジェットの縦幅を変化させる
            if(count($u_row) == 1){
                $widget_height = "140px";
            }else if(count($u_row) == 2){
                $widget_height = "256px";
            }else{
                $widget_height = "371px";
            }
            // CSS ※動的にCSSを変更したいため、ここに記載
            $dom .= "<style>
            #NotificationListListWrap{
                overflow-x: hidden;
                overflow-y: scroll;
                height: $widget_height;
                word-break: break-all;
            }

            #NotificationWidget article.notification_".$nlV['id']."{
                color: #404c66;
                padding: 8px 0;
                border-bottom: 1px solid rgba(0,0,0,0.1);
            }

            #NotificationWidget article.notification_".$nlV['id'].":last-child{
                padding-bottom: 0;
                border-bottom: none;
            }

            #NotificationWidget article.notification_".$nlV['id']." .notification-date_".$nlV['id'].",
            #NotificationWidget article.notification_".$nlV['id']." .notification-sender_".$nlV['id']."{
                color: #666;
                font-size: 0.65em;
            }

            #NotificationWidget article.notification_".$nlV['id']." .notification-date_".$nlV['id']."{
                margin-right: 1em;
            }

            #NotificationWidget article.notification_".$nlV['id']." .notification-title_".$nlV['id']."{
                font-size: 1em;
                margin: 5px 0;
                font-weight: bold;
                line-height: 1.3em;
            }

            #NotificationWidget article.notification_".$nlV['id']." .notification-text_".$nlV['id']."{
                font-size: 0.7em;
            }

            #NotificationWidget article_".$nlV['id']." .brank-notification_".$nlV['id']."{
                color: #fff;
                font-size: 0.9em;
                padding: 10px 0;
                text-align: center;
            }

            #NotificationWidget article.notification_".$nlV['id']." #switch_".$nlV['id']." {
                display: none; /* チェックボックスを除去 */
            }
            #NotificationWidget article.notification_".$nlV['id']." .button_".$nlV['id']." {
                display: block; position: relative; padding: 10px 20px;
            }
            #NotificationWidget article.notification_".$nlV['id']." .icon_".$nlV['id']." { /* アイコン全体のスタイル */
                display: inline-block;
                position: absolute;
                top: 50%;
                transform: translateY(-52%);
                width: 15px;
                height: 15px;
                border: 2px solid #333;
                border-radius: 50%;
            }
            #NotificationWidget article.notification_".$nlV['id']." .icon_".$nlV['id']."::before, .icon_".$nlV['id']."::after { /* 「-」印のスタイル */
                content: '';
                position: absolute;
                top: 50%;
                left: 50%;
                width: 2px; /* 棒の幅（太さ） */
                height: 9px; /* 棒の高さ */
                background: #333; /* 棒の色 */
                transform: translate(-50%,-50%) rotate(90deg); /* デフォルトは「-」印に */
                transition: 0.5s all; /* クリック時のアニメーション設定 */
            }
            #NotificationWidget article.notification_".$nlV['id']." .icon_".$nlV['id']."::after { /* 「＋」印のスタイル */
                content: '';
                position: absolute;
                top: 50%;
                left: 50%;
                width: 2px; /* 棒の幅（太さ） */
                height: 9px; /* 棒の高さ */
                background: #333; /* 棒の色 */
                transform: translate(-50%,-50%) rotate(0deg); /* デフォルトは「＋」印に */
                transition: 0.5s all; /* クリック時のアニメーション設定 */
            }
            /* アイコンと文字の幅 */
            #NotificationWidget article.notification_".$nlV['id']." .open_".$nlV['id'].", .close_".$nlV['id']." {
                margin-left: 20px;
            }
            #NotificationWidget article.notification_".$nlV['id']." .open_".$nlV['id']." { /* 表示ボタンのスタイル */
                display: inline-block; /* デフォルトは表示 */
            }
            #NotificationWidget article.notification_".$nlV['id']." .close_".$nlV['id']." { /* 閉じるボタンのスタイル */
                display: none; /* デフォルトは非表示 */
            }
            #NotificationWidget article.notification_".$nlV['id']." .notification-text_".$nlV['id']." { /* コンテンツのスタイル */
                display: none; /* コンテンツを非表示 */
            }
            /* 以降、チェック時（クリック後）のスタイル */
            #NotificationWidget article.notification_".$nlV['id']." #switch_".$nlV['id'].":checked + .button_".$nlV['id']." > .icon_".$nlV['id']."::before{
                transform: translate(-50%,-50%) rotate(270deg);
            }
            #NotificationWidget article.notification_".$nlV['id']." #switch_".$nlV['id'].":checked + .button_".$nlV['id']." > .icon_".$nlV['id']."::after{
                transform: translate(-50%,-50%) rotate(270deg);
            }
            #NotificationWidget article.notification_".$nlV['id']." #switch_".$nlV['id'].":checked + .button_".$nlV['id']." > .open_".$nlV['id']."{
                display: inline-block; /* 表示ボタンを表示 */
            }
            #NotificationWidget article.notification_".$nlV['id']." #switch_".$nlV['id'].":checked ~ .notification-text_".$nlV['id']." {
                display: inline-block; /* デフォルトは表示 */
                padding: 0 20px 15px;
            }
            #NotificationWidget article.notification_".$nlV['id']." #notification-square_btn_".$nlV['id']." {
                text-align: end;
                margin-right: 0.5em;
                margin-left: 90%;
            }
            </style>";
            $dom .= "</div>";
            $dom .= "</a>";
            $dom .= "</article>";
        }
    }else{

        // お知らせ情報読み込み失敗ログ
        $log->info('Failed to notification information load.',
            array(
                'file' => __FILE__,
                'user_id' => $_SESSION['login']['user_id'],
                'message' => '取得できるお知らせ情報がありません。'
            )
        );

        $dom .= "<article><div class=\"brank-notifications\">取得できるお知らせはありません。</div></article>";
    }
    // レスポンス
    $ret = [
        'state' => 'success',
        'html' => $dom,
    ];

    // お知らせ情報読み込み成功ログ
    $log->info('Successful notification information load.',
        array('file' => __FILE__, 'user_id' => $_SESSION['login']['user_id'])
    );

    header('Content-Type: application/json; charset=utf-8', true);
    echo json_encode($ret);

}catch(Exception $e){

    $ret = [
        'state' => 'error',
        'msg' => $e->getMessage(),
    ];
    $mes = GetMsgEncode($e->getMessage());

    // お知らせ情報読み込み失敗ログ
    $log->info($e);
    $log->info('Failed to notification information load.',
    array(
        'file' => __FILE__,
        'user_id' => $_SESSION['login']['user_id'],
        'message' => $e->getMessage()
    ));

    header('Content-Type: application/json; charset=utf-8', true);
    echo json_encode($ret);
}
?>
