
$(function(){


    $('#NotificationWidget .reload svg').on('click', function(){
        console.log('NotificationWidget reload');
    });

    //TODO ページ読み込み時1秒後に描画
    setTimeout(function(){
        GetAjaxNotificationListData();
    },500);
});


// お知らせ通知情報取得及び画面表示を行う。
function GetAjaxNotificationListData(){
    $.ajax({
        type: "POST",
        url: "./widget/NotificationWidget/get_ajax.php",
        timeout: 10000
    }).done(function(response, textStatus, jqXHR) {
        // 成功時処理
        if(response.state == 'success'){
            // get_ajax.phpからの結果を表示
            $('#NotificationWidget .widget-loading-area').html(response.html);
            $('#NotificationWidget .widget-loading-area').removeClass('d-none');
            $('#NotificationWidget .widget-body .loader_wrap').addClass('d-none');

            // 画像を読み込み終わった後の処理
            $grid.imagesLoaded(function(){
                // 組積造を初期化し、各画像が読み込まれた後にトリガーする
                $grid.masonry('layout');
            });
            console.log(response);
        }else{
            console.log(response.msg);
            return false;
        }
    }).fail(function(XMLHttpRequest,jqXHR, textStatus, errorThrown ) {
        // 失敗時処理
        console.log(XMLHttpRequest);
        $('#NotificationWidget .widget-loading-area').removeClass('d-none');
        $('#NotificationWidget .widget-body .loader_wrap').addClass('d-none');
        $('#NotificationWidget .widget-loading-area').html('<div class="ajax_failed">ウィジェットの読み込みに失敗しました。</div>');
        return false;
    });
};

// 削除ボタンクリック時のお知らせ通知情報削除
function clickNotificationDelete(id){
    $.ajax({
        type: "POST",
        url: "./widget/NotificationWidget/delete_ajax.php",
        data: {"id":id},
        dataType: "json",
        timeout: 10000
    }).done(function(response, textStatus, jqXHR) {
        // 成功時処理
        if(response.state == 'success'){
            GetAjaxNotificationListData();
            console.log(response.msg);
        }else{
            console.log(response.msg);
            return false;
        }
    }).fail(function(XMLHttpRequest, status, e) {
        // 失敗時処理
        console.log(XMLHttpRequest);
        alert(e);
        return false;
    });
};
