<?php
require("../../core/construct.php");
require(CORE_PATH."functions.php");
require(CORE_PATH."session_check.php");
require_once(__DIR__ . "/../../util/utils.php");

try{
    require(SUPER_APPLI_ROOT."model/model.php");
    $sapMDL = new sappModel($sdb, $link);

    if(!isset($_SERVER['HTTP_X_REQUESTED_WITH']) || strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) !== 'xmlhttprequest') {
        throw new Exception('接続が安全ではありません。');
    }

    // user_idの取得
    $user_id = $_SESSION['login']['user_id'];


    // ナンバープレート情報削除開始ログ
    $log->info('Starting number plate detection information delete.',
        array(
            'file' => __FILE__,
            'user_id' => $user_id,
            'id' => $POST['id']
        )
    );

    $POST = filterPost();

    // DBからナンバープレート検知情報を削除する。
    $u_row = $sapMDL->DeleteNumberplateInfo($POST['id']);
    if(!$u_row) throw new Exception('削除するナンバープレート検知情報が見つかりませんでした。');

    // レスポンス
    $ret = [
        'state' => 'success',
        'html' => $dom,
        'id' => $POST['id']
    ];

    // ナンバープレート情報削除成功ログ
    $log->info('Successful number plate detection information delete.',
        array(
            'file' => __FILE__,
            'user_id' => $user_id,
            'id' => $POST['id']
        )
    );

    header('Content-Type: application/json; charset=utf-8', true);
    echo json_encode($ret);

}catch(Exception $e){

    $ret = [
        'state' => 'error',
        'msg' => $e->getMessage(),
    ];
    $mes = GetMsgEncode($e->getMessage());
    $mes_log = GetMsgDecode($mes);

    // ナンバープレート情報削除失敗ログ
    $log->info($e);
    $log->info('Failed to number plate detection information delete.',
    array(
        'file' => __FILE__,
        'user_id' => $user_id,
        'id' => $POST['id'],
        'message' => $e->getMessage()
    )
);

    header('Content-Type: application/json; charset=utf-8', true);
    echo json_encode($ret);
}
?>
